/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.ValidatorProtos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ParsedValueProperties {
    @Nonnull
    private Map<String, ValidatorProtos.PropertySpec> valuePropertyByName = new HashMap<String, ValidatorProtos.PropertySpec>();
    @Nonnull
    private List<String> mandatoryValuePropertyNames = new ArrayList<String>();

    public ParsedValueProperties(@Nonnull ValidatorProtos.PropertySpecList spec) {
        for (ValidatorProtos.PropertySpec propertySpec : spec.getPropertiesList()) {
            this.valuePropertyByName.put(propertySpec.getName(), propertySpec);
            if (!propertySpec.hasMandatory()) continue;
            this.mandatoryValuePropertyNames.add(propertySpec.getName());
        }
        Collections.sort(this.mandatoryValuePropertyNames);
    }

    @Nonnull
    public Map<String, ValidatorProtos.PropertySpec> getValuePropertyByName() {
        return this.valuePropertyByName;
    }

    public List<String> getMandatoryValuePropertyNames() {
        return this.mandatoryValuePropertyNames;
    }

    public void cleanup() {
        this.valuePropertyByName = null;
        this.mandatoryValuePropertyNames = null;
    }
}

