/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.css;

import com.steadystate.css.parser.Token;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.Declaration;
import dev.amp.validator.css.Rule;
import dev.amp.validator.css.TokenType;
import dev.amp.validator.visitor.RuleVisitor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class QualifiedRule
extends Rule {
    @Nonnull
    private List<Rule> rules = new ArrayList<Rule>();
    @Nonnull
    private List<Declaration> declarations;
    @Nonnull
    private List<Token> prelude = new ArrayList<Token>();

    public QualifiedRule() {
        this.declarations = new ArrayList<Declaration>();
    }

    @Override
    public void accept(@Nonnull RuleVisitor visitor) throws CssValidationException {
        visitor.visitQualifiedRule(this);
        for (Declaration declaration : this.declarations) {
            declaration.accept(visitor);
        }
        visitor.leaveQualifiedRule(this);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.QUALIFIED_RULE;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(@Nonnull List<Rule> rules) {
        this.rules = rules;
    }

    public void setDeclarations(@Nonnull List<Declaration> declarations) {
        this.declarations = declarations;
    }

    @Nonnull
    public List<Declaration> getDeclarations() {
        return this.declarations;
    }

    public List<Token> getPrelude() {
        return this.prelude;
    }

    public String ruleName() {
        Object ruleName = "";
        for (int i = 0; i < this.prelude.size(); ++i) {
            Token prelude = this.prelude.get(i);
            if (prelude.toString() == null) continue;
            ruleName = (String)ruleName + prelude.toString();
        }
        return ruleName;
    }
}

