/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.utils.ExtensionsUtils;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.xml.sax.Attributes;

public class ScriptTag {
    private String extensionName = "";
    private String extensionVersion = "";
    private boolean isAmpDomain = false;
    private String path = "";
    private boolean isExtension = false;
    private boolean isRuntime = false;
    private boolean hasValidPath = false;
    @Nonnull
    private ExtensionsUtils.ScriptReleaseVersion releaseVersion = ExtensionsUtils.ScriptReleaseVersion.UNKNOWN;
    @Nonnull
    private static final String AMP_PROJECT_DOMAIN = "https://cdn.ampproject.org/";
    @Nonnull
    private static final Pattern RUNTIME_SCRIPT_PATH_REGEX = Pattern.compile("^(lts\\/)?v0\\.m?js(\\?f=sxg)?$", 2);
    @Nonnull
    private static final Pattern MODULE_LTS_SCRIPT_PATH_REGEX = Pattern.compile("^lts\\/(v0|v0\\/amp-[a-z0-9-]*-[a-z0-9.]*)\\.mjs$", 2);
    @Nonnull
    private static final Pattern NOMODULE_LTS_SCRIPT_PATH_REGEX = Pattern.compile("lts\\/(v0|v0/amp-[a-z0-9-]*-[a-z0-9.]*)\\.js$", 2);
    @Nonnull
    private static final Pattern MODULE_SCRIPT_PATH_REGEX = Pattern.compile("^(v0|v0\\/amp-[a-z0-9-]*-[a-z0-9.]*)\\.mjs$", 2);
    @Nonnull
    private static final Pattern NO_MODULE_SCRIPT_PATH_REGEX = Pattern.compile("(v0|v0\\/amp-[a-z0-9-]*-[a-z0-9.]*)\\.js$", 2);
    @Nonnull
    private static final Pattern LTS_SCRIPT_PATH_REGEX = Pattern.compile("^lts\\/(v0|v0/amp-[a-z0-9-]*-[a-z0-9.]*)\\.js$", 2);
    @Nonnull
    private static final Pattern EXTENSION_SCRIPT_PATH_REGEX = Pattern.compile("^(?:lts\\/)?v0\\/(amp-[a-z0-9-]*)-([a-z0-9.]*)\\.(?:m)?js(?:\\?f=sxg)?$", 2);

    public ScriptTag(@Nonnull String tagName, @Nonnull Attributes attrs) {
        boolean isAsync = false;
        boolean isModule = false;
        boolean isNomodule = false;
        String src = "";
        if (!tagName.equals("SCRIPT")) {
            return;
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            if (attrs.getLocalName(i).equals("async")) {
                isAsync = true;
                continue;
            }
            if (attrs.getLocalName(i).equals("custom-element") || attrs.getLocalName(i).equals("custom-template") || attrs.getLocalName(i).equals("host-service")) {
                this.isExtension = true;
                continue;
            }
            if (attrs.getLocalName(i).equals("nomodule")) {
                isNomodule = true;
                continue;
            }
            if (attrs.getLocalName(i).equals("src")) {
                src = attrs.getValue(i);
                continue;
            }
            if (!attrs.getLocalName(i).equals("type") || !attrs.getValue(i).equals("module")) continue;
            isModule = true;
        }
        if (src.startsWith(AMP_PROJECT_DOMAIN)) {
            this.isAmpDomain = true;
            this.path = src.substring(AMP_PROJECT_DOMAIN.length());
            if (isAsync) {
                if (!this.isExtension && RUNTIME_SCRIPT_PATH_REGEX.matcher(this.path).find()) {
                    this.isRuntime = true;
                }
                Matcher matcher = EXTENSION_SCRIPT_PATH_REGEX.matcher(this.path);
                if (this.isExtension && matcher.find()) {
                    this.hasValidPath = true;
                    MatchResult reResult = matcher.toMatchResult();
                    if (reResult.groupCount() == 2) {
                        this.extensionName = reResult.group(1);
                        this.extensionVersion = reResult.group(2);
                    }
                }
                this.releaseVersion = isModule && MODULE_LTS_SCRIPT_PATH_REGEX.matcher(this.path).find() || isNomodule && NOMODULE_LTS_SCRIPT_PATH_REGEX.matcher(this.path).find() ? ExtensionsUtils.ScriptReleaseVersion.MODULE_NOMODULE_LTS : (isModule && MODULE_SCRIPT_PATH_REGEX.matcher(this.path).find() || isNomodule && NO_MODULE_SCRIPT_PATH_REGEX.matcher(this.path).find() ? ExtensionsUtils.ScriptReleaseVersion.MODULE_NOMODULE : (LTS_SCRIPT_PATH_REGEX.matcher(this.path).find() ? ExtensionsUtils.ScriptReleaseVersion.LTS : ExtensionsUtils.ScriptReleaseVersion.STANDARD));
            }
        }
    }

    public boolean isAmpDomain() {
        return this.isAmpDomain;
    }

    public boolean isRuntime() {
        return this.isRuntime;
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public String getExtensionVersion() {
        return this.extensionVersion;
    }

    public boolean hasValidPath() {
        return this.hasValidPath;
    }

    public String getPath() {
        return this.path;
    }

    @Nonnull
    public ExtensionsUtils.ScriptReleaseVersion getReleaseVersion() {
        return this.releaseVersion;
    }
}

