/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.css;

import com.steadystate.css.parser.Token;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.Declaration;
import dev.amp.validator.css.Rule;
import dev.amp.validator.css.TokenType;
import dev.amp.validator.visitor.RuleVisitor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class AtRule
extends Rule {
    @Nonnull
    private List<Rule> rules = new ArrayList<Rule>();
    @Nonnull
    private List<Declaration> declarations = new ArrayList<Declaration>();
    @Nonnull
    private final String name;
    @Nonnull
    private List<Token> prelude = new ArrayList<Token>();

    public AtRule(@Nonnull String name) {
        this.name = name;
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.AT_RULE;
    }

    public void setRules(@Nonnull List<Rule> rules) {
        this.rules = rules;
    }

    public void setDeclarations(@Nonnull List<Declaration> declarations) {
        this.declarations = declarations;
    }

    public String getName() {
        if (this.name.length() > 0) {
            return this.name.substring(1);
        }
        return this.name;
    }

    public List<Token> getPrelude() {
        return this.prelude;
    }

    @Override
    public void accept(@Nonnull RuleVisitor visitor) throws CssValidationException {
        visitor.visitAtRule(this);
        for (Rule rule : this.rules) {
            rule.accept(visitor);
        }
        for (Declaration declaration : this.declarations) {
            declaration.accept(visitor);
        }
        visitor.leaveAtRule(this);
    }
}

