/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.utils.ExtensionsUtils;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.xml.sax.Attributes;

public class ParsedHtmlTag {
    @Nonnull
    private String tagName;
    @Nonnull
    private final Attributes attrs;
    private HashMap<String, String> attrsByKey;
    private static final Pattern MODULE_LTS_SCRIPT_SRC_REGEX = Pattern.compile("^https:\\/\\/cdn\\.ampproject\\.org\\/lts\\/(v0|v0/amp-[a-z0-9-]*-[a-z0-9.]*)\\.mjs$", 2);
    private static final Pattern NOMODULE_LTS_SCRIPT_SRC_REGEX = Pattern.compile("^https:\\/\\/cdn\\.ampproject\\.org\\/lts\\/(v0|v0/amp-[a-z0-9-]*-[a-z0-9.]*)\\.js$", 2);
    private static final Pattern MODULE_SCRIPT_SRC_REGEX = Pattern.compile("^https://cdn\\.ampproject\\.org\\/(v0|v0/amp-[a-z0-9-]*-[a-z0-9.]*)\\.mjs$", 2);
    private static final Pattern NOMODULE_SCRIPT_SRC_REGEX = Pattern.compile("^https:\\/\\/cdn\\.ampproject\\.org\\/(v0|v0/amp-[a-z0-9-]*-[a-z0-9.]*)\\.js$", 2);
    private static final Pattern LTS_SCRIPT_SRC_REGEX = Pattern.compile("^https:\\/\\/cdn\\.ampproject\\.org\\/lts\\/(v0|v0/amp-[a-z0-9-]*-[a-z0-9.]*)\\.js$", 2);

    public ParsedHtmlTag(@Nonnull String tagName, @Nonnull Attributes attributes) {
        this.tagName = tagName.toUpperCase();
        this.attrs = attributes;
        this.attrsByKey = null;
    }

    public String lowerName() {
        return this.tagName.toLowerCase();
    }

    public Attributes attrs() {
        return this.attrs;
    }

    public HashMap<String, String> attrsByKey() {
        if (this.attrsByKey == null) {
            this.attrsByKey = new HashMap();
            for (int i = 0; i < this.attrs.getLength(); ++i) {
                this.attrsByKey.put(this.attrs.getLocalName(i), this.attrs.getValue(i));
            }
        }
        return this.attrsByKey;
    }

    public String hasDuplicateAttrs() {
        String lastAttrName = "";
        String lastAttrValue = "";
        for (int i = 0; i < this.attrs.getLength(); ++i) {
            if (lastAttrName.equals(this.attrs.getLocalName(i)) && !lastAttrValue.equals(this.attrs.getValue(i))) {
                return this.attrs.getLocalName(i);
            }
            lastAttrName = this.attrs.getLocalName(i);
            lastAttrValue = this.attrs.getValue(i);
        }
        return null;
    }

    public String getValue(@Nonnull String attrName, int index) {
        String val = this.attrs.getValue(index);
        if (val != null && val.equals(attrName.toLowerCase())) {
            return "";
        }
        return val;
    }

    private String extensionScriptNameAttribute() {
        if ("SCRIPT".equals(this.upperName())) {
            for (String attribute : ExtensionsUtils.EXTENSION_SCRIPT_NAMES) {
                if (!this.attrsByKey().containsKey(attribute)) continue;
                return attribute;
            }
        }
        return "";
    }

    public boolean isExtensionScript() {
        return !this.extensionScriptNameAttribute().isEmpty();
    }

    private String getAttrValueOrNull(@Nonnull String name) {
        return this.attrsByKey().get(name);
    }

    public boolean isAmpRuntimeScript() {
        String src = this.getAttrValueOrNull("src");
        if (src == null) {
            return false;
        }
        return this.isAsyncScriptTag() && !this.isExtensionScript() && src.startsWith("https://cdn.ampproject.org/") && (src.endsWith("/v0.js") || src.endsWith("/v0.mjs") || src.endsWith("/v0.mjs?f=sxg"));
    }

    private boolean isAsyncScriptTag() {
        return "SCRIPT".equals(this.upperName()) && this.attrsByKey().containsKey("async") && this.attrsByKey().containsKey("src");
    }

    public boolean isModuleLtsScriptTag() {
        String type = this.getAttrValueOrNull("type");
        if (type == null) {
            return false;
        }
        String src = this.getAttrValueOrNull("src");
        if (src == null) {
            return false;
        }
        return this.isAsyncScriptTag() && type.equals("module") && MODULE_LTS_SCRIPT_SRC_REGEX.matcher(src).find();
    }

    public boolean isNomoduleLtsScriptTag() {
        String src = this.getAttrValueOrNull("src");
        if (src == null) {
            return false;
        }
        return this.isAsyncScriptTag() && this.attrsByKey().containsKey("nomodule") && NOMODULE_LTS_SCRIPT_SRC_REGEX.matcher(src).find();
    }

    public boolean isModuleScriptTag() {
        String type = this.getAttrValueOrNull("type");
        if (type == null) {
            return false;
        }
        String src = this.getAttrValueOrNull("src");
        if (src == null) {
            return false;
        }
        return this.isAsyncScriptTag() && type.equals("module") && MODULE_SCRIPT_SRC_REGEX.matcher(src).find();
    }

    public boolean isNomoduleScriptTag() {
        String src = this.getAttrValueOrNull("src");
        if (src == null) {
            return false;
        }
        return this.isAsyncScriptTag() && this.attrsByKey().containsKey("nomodule") && NOMODULE_SCRIPT_SRC_REGEX.matcher(src).find();
    }

    public boolean isLtsScriptTag() {
        String src = this.getAttrValueOrNull("src");
        if (src == null) {
            return false;
        }
        return this.isAsyncScriptTag() && LTS_SCRIPT_SRC_REGEX.matcher(src).find();
    }

    public void cleanup() {
        this.tagName = null;
        this.attrsByKey = null;
    }

    public String upperName() {
        return this.tagName.toUpperCase();
    }

    public boolean isEmpty() {
        return this.tagName.length() == 0;
    }
}

