/*
 * Decompiled with CFR 0.152.
 */
package spring.boot.admin.turbine.zuul.filters;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.SimpleRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;

public class TurbineRouteLocator
extends SimpleRouteLocator {
    private final Map<String, ZuulProperties.ZuulRoute> routes;
    private DiscoveryClient discovery;

    public TurbineRouteLocator(ZuulProperties.ZuulRoute route, String servletPath, ZuulProperties zuulProperties, DiscoveryClient discovery) {
        super(servletPath, zuulProperties);
        this.routes = Collections.singletonMap(route.getPath(), route);
        this.discovery = discovery;
    }

    protected Map<String, ZuulProperties.ZuulRoute> locateRoutes() {
        return this.routes;
    }

    public Route getMatchingRoute(String path) {
        Route route = super.getMatchingRoute(path);
        if (route == null) {
            return route;
        }
        String location = route.getLocation();
        if (!location.startsWith("http:") && !location.startsWith("https:")) {
            location = this.resolveServiceId(location);
        }
        String targetPath = route.getPath() + "/turbine.stream";
        return new Route(route.getId(), targetPath, location, route.getPrefix(), route.getRetryable(), route.getSensitiveHeaders());
    }

    private String resolveServiceId(String location) {
        List instances = this.discovery.getInstances(location);
        if (instances.isEmpty()) {
            throw new IllegalStateException("No instance found for serviceId '" + location + "'");
        }
        return ((ServiceInstance)instances.get(0)).getUri().toString();
    }
}

