/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.s3.base;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hubspot.deploy.S3Artifact;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.runner.base.sentry.SingularityRunnerExceptionNotifier;
import com.hubspot.singularity.s3.base.config.SingularityS3Configuration;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jets3t.service.S3Service;
import org.jets3t.service.model.S3Object;
import org.slf4j.Logger;

public class S3ArtifactChunkDownloader
implements Callable<Path> {
    private final SingularityS3Configuration configuration;
    private final S3Service s3;
    private final S3Artifact s3Artifact;
    private final Path downloadTo;
    private final int chunk;
    private final long chunkSize;
    private final long length;
    private final Logger log;
    private final SingularityRunnerExceptionNotifier exceptionNotifier;
    private int retryNum;

    public S3ArtifactChunkDownloader(SingularityS3Configuration configuration, Logger log, S3Service s3, S3Artifact s3Artifact, Path downloadTo, int chunk, long chunkSize, long length, SingularityRunnerExceptionNotifier exceptionNotifier) {
        this.configuration = configuration;
        this.log = log;
        this.s3 = s3;
        this.s3Artifact = s3Artifact;
        this.downloadTo = downloadTo;
        this.chunk = chunk;
        this.chunkSize = chunkSize;
        this.length = length;
        this.exceptionNotifier = exceptionNotifier;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Path call() throws Exception {
        long start = System.currentTimeMillis();
        ExecutorService chunkExecutorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("S3ArtifactDownloaderChunk-" + this.chunk + "-Thread-%d").build());
        try {
            while ((long)this.retryNum <= this.configuration.getS3ChunkRetries()) {
                long timeout = System.currentTimeMillis();
                Future<Path> future = chunkExecutorService.submit(this.createDownloader(this.retryNum));
                try {
                    Path path = future.get(this.configuration.getS3ChunkDownloadTimeoutMillis(), TimeUnit.MILLISECONDS);
                    return path;
                }
                catch (TimeoutException te) {
                    block10: {
                        this.log.error("Chunk {} (retry {}) for {} timed out after {} - total duration {}", new Object[]{this.chunk, this.retryNum, this.s3Artifact.getFilename(), JavaUtils.duration((long)timeout), JavaUtils.duration((long)start)});
                        future.cancel(true);
                        if ((long)this.retryNum == this.configuration.getS3ChunkRetries()) {
                            this.exceptionNotifier.notify((Throwable)te, (Map)ImmutableMap.of((Object)"filename", (Object)this.s3Artifact.getFilename(), (Object)"chunk", (Object)Integer.toString(this.chunk), (Object)"retry", (Object)Integer.toString(this.retryNum)));
                        }
                        break block10;
                        catch (InterruptedException ie) {
                            this.log.warn("Chunk {} (retry {}) for {} interrupted", new Object[]{this.chunk, this.retryNum, this.s3Artifact.getFilename()});
                            this.exceptionNotifier.notify((Throwable)ie, (Map)ImmutableMap.of((Object)"filename", (Object)this.s3Artifact.getFilename(), (Object)"chunk", (Object)Integer.toString(this.chunk), (Object)"retry", (Object)Integer.toString(this.retryNum)));
                            break block10;
                        }
                        catch (Throwable t) {
                            this.log.error("Error while downloading chunk {} (retry {}) for {}", new Object[]{this.chunk, this.retryNum, this.s3Artifact.getFilename(), t});
                            this.exceptionNotifier.notify(t, (Map)ImmutableMap.of((Object)"filename", (Object)this.s3Artifact.getFilename(), (Object)"chunk", (Object)Integer.toString(this.chunk), (Object)"retry", (Object)Integer.toString(this.retryNum)));
                        }
                    }
                    ++this.retryNum;
                }
            }
            throw new IllegalStateException(String.format("Chunk %s for %s failed to download after %s tries", this.chunk, this.s3Artifact.getFilename(), this.retryNum + 1));
        }
        finally {
            chunkExecutorService.shutdownNow();
        }
    }

    private Callable<Path> createDownloader(final int retryNum) {
        return new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                Path chunkPath = S3ArtifactChunkDownloader.this.chunk == 0 ? S3ArtifactChunkDownloader.this.downloadTo : Paths.get(S3ArtifactChunkDownloader.this.downloadTo + "_" + S3ArtifactChunkDownloader.this.chunk + "_" + retryNum, new String[0]);
                chunkPath.toFile().deleteOnExit();
                long startTime = System.currentTimeMillis();
                long byteRangeStart = (long)S3ArtifactChunkDownloader.this.chunk * S3ArtifactChunkDownloader.this.chunkSize;
                long byteRangeEnd = Math.min((long)(S3ArtifactChunkDownloader.this.chunk + 1) * S3ArtifactChunkDownloader.this.chunkSize - 1L, S3ArtifactChunkDownloader.this.length);
                S3ArtifactChunkDownloader.this.log.info("Downloading {} - chunk {} (retry {}) ({}-{}) to {}", new Object[]{S3ArtifactChunkDownloader.this.s3Artifact.getFilename(), S3ArtifactChunkDownloader.this.chunk, retryNum, byteRangeStart, byteRangeEnd, chunkPath});
                S3Object fetchedObject = S3ArtifactChunkDownloader.this.s3.getObject(S3ArtifactChunkDownloader.this.s3Artifact.getS3Bucket(), S3ArtifactChunkDownloader.this.s3Artifact.getS3ObjectKey(), null, null, null, null, Long.valueOf(byteRangeStart), Long.valueOf(byteRangeEnd));
                try (InputStream is = fetchedObject.getDataInputStream();){
                    Files.copy(is, chunkPath, StandardCopyOption.REPLACE_EXISTING);
                }
                S3ArtifactChunkDownloader.this.log.info("Finished downloading chunk {} (retry {}) of {} ({} bytes) in {}", new Object[]{S3ArtifactChunkDownloader.this.chunk, retryNum, S3ArtifactChunkDownloader.this.s3Artifact.getFilename(), byteRangeEnd - byteRangeStart, JavaUtils.duration((long)startTime)});
                return chunkPath;
            }
        };
    }
}

