/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.s3.base;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hubspot.singularity.s3.base.config.SingularityS3Configuration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileMetricsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileMetricsReporter.class);
    protected final SingularityS3Configuration configuration;
    protected final ObjectMapper metricsObjectMapper;
    protected final MetricRegistry registry;
    protected final ScheduledExecutorService fileReporterExecutor;

    public AbstractFileMetricsReporter(MetricRegistry registry, SingularityS3Configuration configuration, ObjectMapper metricsObjectMapper) {
        this.registry = registry;
        this.configuration = configuration;
        this.metricsObjectMapper = metricsObjectMapper;
        this.fileReporterExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("metrics-file-reporter").build());
        if (configuration.getMetricsFilePath().isPresent()) {
            this.startFileReporter();
        }
    }

    private void startFileReporter() {
        this.fileReporterExecutor.scheduleAtFixedRate(() -> {
            File metricsFile = new File((String)this.configuration.getMetricsFilePath().get());
            try (FileWriter metricsFileWriter = new FileWriter(metricsFile, false);){
                metricsFileWriter.write(this.metricsObjectMapper.writeValueAsString((Object)this.registry.getMetrics()));
                ((Writer)metricsFileWriter).flush();
            }
            catch (IOException e) {
                LOG.error("Unable to write metrics to file", (Throwable)e);
            }
        }, 10L, 30L, TimeUnit.SECONDS);
    }
}

