/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.hubspot.mesos.protos.MesosTaskState;
import com.hubspot.singularity.ExtendedTaskState;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.mesos.v1.Protos;

public class MesosUtils {
    private static final Map<Protos.TaskState, ExtendedTaskState> map = Maps.newHashMapWithExpectedSize((int)ExtendedTaskState.values().length);

    public static Path getTaskDirectoryPath(String taskId) {
        return Paths.get(MesosUtils.getSafeTaskIdForDirectory(taskId), new String[0]).toAbsolutePath();
    }

    public static String getSafeTaskIdForDirectory(String taskId) {
        return taskId.replace(":", "_");
    }

    public static String formatForLogging(Object object) {
        return object.toString().replace("\n", "").replaceAll("( )+", " ");
    }

    public static ExtendedTaskState fromTaskState(Protos.TaskState taskState) {
        ExtendedTaskState extendedTaskState = map.get(taskState);
        Preconditions.checkArgument((extendedTaskState != null ? 1 : 0) != 0, (String)"No ExtendedTaskState for TaskState %s", (Object)taskState);
        return extendedTaskState;
    }

    static {
        for (ExtendedTaskState extendedTaskState : ExtendedTaskState.values()) {
            if (!extendedTaskState.toTaskState().isPresent()) continue;
            map.put(Protos.TaskState.valueOf((String)((MesosTaskState)extendedTaskState.toTaskState().get()).name()), extendedTaskState);
        }
        for (ExtendedTaskState extendedTaskState : Protos.TaskState.values()) {
            if (map.get(extendedTaskState) != null) continue;
            throw new IllegalStateException("No ExtendedTaskState provided for TaskState " + extendedTaskState + ", you probably have incompatible versions of Mesos and Singularity.");
        }
    }
}

