/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.utils;

import com.google.inject.Inject;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.mesos.ExecutorDriver;
import org.apache.mesos.Protos;
import org.slf4j.Logger;

public class ExecutorUtils {
    private final SingularityExecutorConfiguration configuration;

    @Inject
    public ExecutorUtils(SingularityExecutorConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_EXIT"})
    public void sendStatusUpdate(ExecutorDriver driver, Protos.TaskID taskID, Protos.TaskState taskState, String message, Logger logger) {
        logger.info("Sending status update \"{}\" ({})", (Object)message, (Object)taskState.name());
        message = message.substring(0, Math.min(this.configuration.getMaxTaskMessageLength(), message.length()));
        try {
            Protos.TaskStatus.Builder builder = Protos.TaskStatus.newBuilder().setTaskId(taskID).setState(taskState).setMessage(message);
            driver.sendStatusUpdate(builder.build());
        }
        catch (Throwable t) {
            try {
                logger.error("Exception while sending status updates, exiting", t);
            }
            finally {
                System.exit(4);
            }
        }
    }
}

