/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hubspot.singularity.SingularityS3FormatHelper;
import com.hubspot.singularity.SingularityS3UploaderFile;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.executor.SingularityExecutorLogrotateFrequency;
import com.hubspot.singularity.executor.TemplateManager;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.config.SingularityExecutorLogrotateAdditionalFile;
import com.hubspot.singularity.executor.models.LogrotateCronTemplateContext;
import com.hubspot.singularity.executor.models.LogrotateTemplateContext;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import com.hubspot.singularity.runner.base.configuration.SingularityRunnerBaseConfiguration;
import com.hubspot.singularity.runner.base.shared.JsonObjectFileHelper;
import com.hubspot.singularity.runner.base.shared.S3UploadMetadata;
import com.hubspot.singularity.runner.base.shared.SimpleProcessManager;
import com.hubspot.singularity.runner.base.shared.TailMetadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class SingularityExecutorTaskLogManager {
    private final SingularityExecutorTaskDefinition taskDefinition;
    private final TemplateManager templateManager;
    private final SingularityRunnerBaseConfiguration baseConfiguration;
    private final SingularityExecutorConfiguration configuration;
    private final Logger log;
    private final JsonObjectFileHelper jsonObjectFileHelper;
    private final SingularityExecutorLogrotateFrequency logrotateFrequency;
    private final ScheduledExecutorService logCheckExecutor;
    private Future<?> logCheckFuture = null;

    public SingularityExecutorTaskLogManager(SingularityExecutorTaskDefinition taskDefinition, TemplateManager templateManager, SingularityRunnerBaseConfiguration baseConfiguration, SingularityExecutorConfiguration configuration, Logger log, JsonObjectFileHelper jsonObjectFileHelper, boolean startServiceLogChecker) {
        this.log = log;
        this.taskDefinition = taskDefinition;
        this.templateManager = templateManager;
        this.configuration = configuration;
        this.baseConfiguration = baseConfiguration;
        this.jsonObjectFileHelper = jsonObjectFileHelper;
        this.logrotateFrequency = taskDefinition.getExecutorData().getLogrotateFrequency().orElse(configuration.getLogrotateFrequency());
        this.logCheckExecutor = startServiceLogChecker ? Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("service-log-checker-%d").build()) : null;
    }

    public void setup() {
        this.ensureServiceOutExists();
        this.writeLogrotateFile();
        this.writeTailMetadata(false);
        this.writeS3MetadataFileForRotatedFiles(false);
        this.startLogChecker();
    }

    private void startLogChecker() {
        try {
            if (this.logCheckExecutor != null) {
                this.log.info("Starting service log checker to rotate logs over {} MB", this.configuration.getMaxServiceLogSizeMb());
                this.logCheckFuture = this.logCheckExecutor.scheduleAtFixedRate(this::checkServiceLogSize, 5L, 5L, TimeUnit.MINUTES);
            }
        }
        catch (Throwable t) {
            this.log.warn("Could not start service log checker", t);
        }
    }

    private void stopLogChecker() {
        try {
            if (this.logCheckFuture != null) {
                this.logCheckFuture.cancel(true);
            }
            if (this.logCheckExecutor != null) {
                this.logCheckExecutor.shutdown();
            }
        }
        catch (Throwable t) {
            this.log.warn("Coud not properly shut down log checker", t);
        }
    }

    private void checkServiceLogSize() {
        try {
            long fileBytes = this.taskDefinition.getServiceLogOutPath().toFile().length();
            long fileMb = fileBytes / 1024L / 1024L;
            this.log.debug("service log is currently {} MB (limit before logrotate: {} MB)", (Object)fileMb, this.configuration.getMaxServiceLogSizeMb());
            if (this.configuration.getMaxServiceLogSizeMb().isPresent() && fileMb > this.configuration.getMaxServiceLogSizeMb().get()) {
                this.manualLogrotate();
            }
        }
        catch (Throwable t) {
            this.log.warn("Could not run file size check on service log", t);
        }
    }

    @SuppressFBWarnings
    private boolean writeS3MetadataFileForRotatedFiles(boolean finished) {
        Path serviceLogOutPath = this.taskDefinition.getServiceLogOutPath();
        Path serviceLogParent = serviceLogOutPath.getParent();
        Path logrotateDirectory = serviceLogParent.resolve(this.configuration.getLogrotateToDirectory());
        ArrayList<String> handledLogs = new ArrayList<String>();
        int index = 1;
        boolean result = true;
        for (SingularityS3UploaderFile additionalFile : this.taskDefinition.getExecutorData().getS3UploaderAdditionalFiles()) {
            String fileGlob;
            Path directory;
            Path path = directory = additionalFile.getDirectory().isPresent() ? this.taskDefinition.getTaskDirectoryPath().resolve((String)additionalFile.getDirectory().get()) : this.taskDefinition.getTaskDirectoryPath();
            if (!directory.toAbsolutePath().startsWith(this.taskDefinition.getTaskDirectoryPath())) {
                this.log.warn("Received request to upload files in directory outside task sandbox; these will not be uploaded ({})", (Object)directory);
                continue;
            }
            String string = fileGlob = additionalFile.getFilename() != null && additionalFile.getFilename().contains("*") ? additionalFile.getFilename() : String.format("%s*.[gb]z*", additionalFile.getFilename());
            result = result && this.writeS3MetadataFile(additionalFile.getS3UploaderFilenameHint().orElse(String.format("file%d", index)), directory, fileGlob, additionalFile.getS3UploaderBucket(), additionalFile.getS3UploaderKeyPattern(), finished, additionalFile.getS3StorageClass().isPresent() ? additionalFile.getS3StorageClass() : this.taskDefinition.getExecutorData().getS3StorageClass(), additionalFile.getApplyS3StorageClassAfterBytes().isPresent() ? additionalFile.getApplyS3StorageClassAfterBytes() : this.taskDefinition.getExecutorData().getApplyS3StorageClassAfterBytes(), additionalFile.isCheckSubdirectories());
            ++index;
            handledLogs.add(additionalFile.getFilename());
        }
        if (!handledLogs.contains(this.taskDefinition.getServiceLogFileName())) {
            result = result && this.writeS3MetadataFile("default", logrotateDirectory, String.format("%s*.[gb]z*", this.taskDefinition.getServiceLogOutPath().getFileName()), Optional.empty(), Optional.empty(), finished, this.taskDefinition.getExecutorData().getS3StorageClass(), this.taskDefinition.getExecutorData().getApplyS3StorageClassAfterBytes(), false);
        }
        return result;
    }

    private void writeLogrotateFile() {
        File hourlyLogrotateDir;
        this.log.info("Writing non-hourly logrotate configuration file to {}", (Object)this.getLogrotateConfPath());
        this.templateManager.writeLogrotateFile(this.getLogrotateConfPath(), new LogrotateTemplateContext(this.configuration, this.taskDefinition));
        Optional<SingularityExecutorLogrotateFrequency> additionalFileFrequency = this.getAdditionalHourlyFileFrequency();
        boolean needsHourlyCronWithForceLogrotate = additionalFileFrequency.isPresent() && additionalFileFrequency.get().getCronSchedule().isPresent();
        boolean globalLogrotateRequiresCronWithForceLogrotate = this.logrotateFrequency.getCronSchedule().isPresent();
        boolean needsHourlyCronWithNonForcedLogrotate = this.requiresSizeBasedRotation();
        if ((needsHourlyCronWithForceLogrotate || globalLogrotateRequiresCronWithForceLogrotate || needsHourlyCronWithNonForcedLogrotate) && !(hourlyLogrotateDir = new File(this.configuration.getLogrotateHourlyConfDirectory())).exists() && !hourlyLogrotateDir.mkdir()) {
            this.log.warn("Could not create hourly logrotate directory at {}", (Object)this.configuration.getLogrotateHourlyConfDirectory());
        }
        if (needsHourlyCronWithForceLogrotate) {
            this.log.info("Writing hourly logrotate configuration file to {}", (Object)this.getLogrotateHourlyConfPath());
            this.templateManager.writeHourlyLogrotateFile(this.getLogrotateHourlyConfPath(), new LogrotateTemplateContext(this.configuration, this.taskDefinition));
        }
        if (this.requiresSizeBasedRotation()) {
            this.log.info("Writing size-based logrotate configuration file to {}", (Object)this.getLogrotateSizeBasedConfPath());
            this.templateManager.writeSizeBasedLogrotateFile(this.getLogrotateSizeBasedConfPath(), new LogrotateTemplateContext(this.configuration, this.taskDefinition));
        }
        if (needsHourlyCronWithForceLogrotate || globalLogrotateRequiresCronWithForceLogrotate || needsHourlyCronWithNonForcedLogrotate) {
            String cronScheduleString = (String)SingularityExecutorLogrotateFrequency.HOURLY.getCronSchedule().get();
            this.log.info("Writing logrotate cron entry with schedule '{}' to {}", (Object)cronScheduleString, (Object)this.getLogrotateCronPath());
            this.templateManager.writeCronEntryForLogrotate(this.getLogrotateCronPath(), new LogrotateCronTemplateContext(this.configuration, this.taskDefinition, SingularityExecutorLogrotateFrequency.HOURLY, this.getLogrotateHourlyConfPath().toString(), this.getLogrotateSizeBasedConfPath().toString()));
        }
    }

    private Optional<SingularityExecutorLogrotateFrequency> getAdditionalHourlyFileFrequency() {
        for (SingularityExecutorLogrotateAdditionalFile file : this.configuration.getLogrotateAdditionalFiles()) {
            if (!file.getLogrotateFrequencyOverride().isPresent() || !file.getLogrotateFrequencyOverride().get().equals((Object)SingularityExecutorLogrotateFrequency.HOURLY) || !file.getLogrotateFrequencyOverride().get().getCronSchedule().isPresent()) continue;
            return Optional.of(file.getLogrotateFrequencyOverride().get());
        }
        return Optional.empty();
    }

    private boolean requiresSizeBasedRotation() {
        return this.configuration.getLogrotateAdditionalFiles().stream().anyMatch(logrotateAdditionalFile -> logrotateAdditionalFile.getLogrotateSizeOverride().isPresent() && !logrotateAdditionalFile.getLogrotateSizeOverride().get().isEmpty());
    }

    @SuppressFBWarnings
    public boolean teardown() {
        this.stopLogChecker();
        boolean writeTailMetadataSuccess = this.writeTailMetadata(true);
        this.ensureServiceOutExists();
        if (this.taskDefinition.shouldLogrotateLogFile()) {
            this.copyLogTail();
        }
        boolean writeS3MetadataForNonLogRotatedFileSuccess = true;
        if (!this.taskDefinition.shouldLogrotateLogFile()) {
            writeS3MetadataForNonLogRotatedFileSuccess = this.writeS3MetadataFile("unrotated", this.taskDefinition.getServiceLogOutPath().getParent(), this.taskDefinition.getServiceLogOutPath().getFileName().toString(), Optional.empty(), Optional.empty(), true, this.taskDefinition.getExecutorData().getS3StorageClass(), this.taskDefinition.getExecutorData().getApplyS3StorageClassAfterBytes(), false);
        }
        if (this.manualLogrotate()) {
            boolean removeLogRotateFileSuccess = this.removeLogrotateFile();
            this.removeEmptyServiceOut();
            boolean writeS3MetadataForLogrotatedFilesSuccess = this.writeS3MetadataFileForRotatedFiles(true);
            return writeTailMetadataSuccess && removeLogRotateFileSuccess && writeS3MetadataForLogrotatedFilesSuccess && writeS3MetadataForNonLogRotatedFileSuccess;
        }
        return this.removeLogrotateFile();
    }

    private void copyLogTail() {
        if (this.configuration.getTailLogLinesToSave() <= 0) {
            return;
        }
        Path tailOfLogPath = this.taskDefinition.getServiceFinishedTailLogPath();
        if (Files.exists(tailOfLogPath, new LinkOption[0])) {
            this.log.debug("{} already existed, skipping tail", (Object)tailOfLogPath);
            return;
        }
        ImmutableList cmd = ImmutableList.of((Object)"tail", (Object)"-n", (Object)Integer.toString(this.configuration.getTailLogLinesToSave()), (Object)this.taskDefinition.getServiceLogOut());
        try {
            new SimpleProcessManager(this.log).runCommand((List)cmd, ProcessBuilder.Redirect.to(tailOfLogPath.toFile()));
        }
        catch (Throwable t) {
            this.log.error("Failed saving tail of log {} to {}", new Object[]{this.taskDefinition.getServiceLogOut(), this.taskDefinition.getServiceFinishedTailLogPath(), t});
        }
    }

    public boolean removeLogrotateFile() {
        boolean deleted = false;
        try {
            if (Files.exists(this.getLogrotateConfPath(), new LinkOption[0])) {
                deleted = Files.deleteIfExists(this.getLogrotateConfPath());
                this.log.debug("Deleted {} : {}", (Object)this.getLogrotateConfPath(), (Object)deleted);
            } else {
                deleted = true;
            }
        }
        catch (Throwable t) {
            this.log.debug("Couldn't delete {}", (Object)this.getLogrotateConfPath(), (Object)t);
            return false;
        }
        Optional<SingularityExecutorLogrotateFrequency> additionalFileFreq = this.getAdditionalHourlyFileFrequency();
        try {
            if (additionalFileFreq.isPresent() && additionalFileFreq.get().getCronSchedule().isPresent() || this.logrotateFrequency.getCronSchedule().isPresent()) {
                boolean hourlyConfDeleted = !Files.exists(this.getLogrotateHourlyConfPath(), new LinkOption[0]) || Files.deleteIfExists(this.getLogrotateHourlyConfPath());
                this.log.debug("Deleted {} : {}", (Object)this.getLogrotateHourlyConfPath(), (Object)hourlyConfDeleted);
                deleted = deleted && hourlyConfDeleted;
            }
        }
        catch (Throwable t) {
            this.log.debug("Couldn't delete {}", (Object)this.getLogrotateHourlyConfPath(), (Object)t);
            return false;
        }
        try {
            if (this.requiresSizeBasedRotation()) {
                boolean sizeBasedConfDeleted = !Files.exists(this.getLogrotateSizeBasedConfPath(), new LinkOption[0]) || Files.deleteIfExists(this.getLogrotateSizeBasedConfPath());
                this.log.debug("Deleted {} : {}", (Object)this.getLogrotateSizeBasedConfPath(), (Object)sizeBasedConfDeleted);
                deleted = deleted && sizeBasedConfDeleted;
            }
        }
        catch (Throwable t) {
            this.log.debug("Couldn't delete {}", (Object)this.getLogrotateSizeBasedConfPath(), (Object)t);
            return false;
        }
        try {
            if (additionalFileFreq.isPresent() && additionalFileFreq.get().getCronSchedule().isPresent() || this.logrotateFrequency.getCronSchedule().isPresent()) {
                boolean cronDeleted = !Files.exists(this.getLogrotateCronPath(), new LinkOption[0]) || Files.deleteIfExists(this.getLogrotateCronPath());
                this.log.debug("Deleted {} : {}", (Object)this.getLogrotateCronPath(), (Object)cronDeleted);
                deleted = deleted && cronDeleted;
            }
        }
        catch (Throwable t) {
            this.log.debug("Couldn't delete {}", (Object)this.getLogrotateCronPath(), (Object)t);
            return false;
        }
        return deleted;
    }

    public boolean manualLogrotate() {
        if (!Files.exists(this.getLogrotateConfPath(), new LinkOption[0])) {
            this.log.info("{} did not exist, skipping manual logrotation", (Object)this.getLogrotateConfPath());
            return true;
        }
        ImmutableList command = ImmutableList.of((Object)this.configuration.getLogrotateCommand(), (Object)"-f", (Object)"-s", (Object)this.taskDefinition.getLogrotateStateFilePath().toString(), (Object)this.getLogrotateConfPath().toString());
        try {
            new SimpleProcessManager(this.log).runCommand((List)command);
            return true;
        }
        catch (Throwable t) {
            this.log.warn("Tried to manually logrotate using {}, but caught", (Object)this.getLogrotateConfPath(), (Object)t);
            return false;
        }
    }

    private void ensureServiceOutExists() {
        try {
            if (!Files.exists(this.taskDefinition.getServiceLogOutPath(), new LinkOption[0])) {
                Files.createFile(this.taskDefinition.getServiceLogOutPath(), new FileAttribute[0]);
            }
        }
        catch (FileAlreadyExistsException faee) {
            this.log.debug("Executor out {} already existed", (Object)this.taskDefinition.getServiceLogOut());
        }
        catch (Throwable t) {
            this.log.error("Failed creating executor out {}", (Object)this.taskDefinition.getServiceLogOut(), (Object)t);
        }
    }

    private void removeEmptyServiceOut() {
        try {
            if (Files.exists(this.taskDefinition.getServiceLogOutPath(), new LinkOption[0]) && Files.size(this.taskDefinition.getServiceLogOutPath()) == 0L) {
                Files.deleteIfExists(this.taskDefinition.getServiceLogOutPath());
            }
        }
        catch (Throwable t) {
            this.log.error("Failed checking/deleting executor out {}", (Object)this.taskDefinition.getServiceLogOut(), (Object)t);
        }
    }

    private boolean writeTailMetadata(boolean finished) {
        if (!this.taskDefinition.getExecutorData().getLoggingTag().isPresent()) {
            if (!finished) {
                this.log.warn("Not writing logging metadata because logging tag is absent");
            }
            return true;
        }
        TailMetadata tailMetadata = new TailMetadata(this.taskDefinition.getServiceLogOut(), (String)this.taskDefinition.getExecutorData().getLoggingTag().get(), this.taskDefinition.getExecutorData().getLoggingExtraFields(), finished);
        Path path = TailMetadata.getTailMetadataPath((Path)Paths.get(this.baseConfiguration.getLogWatcherMetadataDirectory(), new String[0]), (String)this.baseConfiguration.getLogWatcherMetadataSuffix(), (TailMetadata)tailMetadata);
        return this.jsonObjectFileHelper.writeObject((Object)tailMetadata, path, this.log);
    }

    private String getS3KeyPattern(String s3KeyPattern) {
        SingularityTaskId singularityTaskId = this.getSingularityTaskId();
        return SingularityS3FormatHelper.getS3KeyFormat((String)s3KeyPattern, (SingularityTaskId)singularityTaskId, (Optional)this.taskDefinition.getExecutorData().getLoggingTag(), (String)this.taskDefinition.getExecutorData().getRequestGroup().orElse("default"));
    }

    private SingularityTaskId getSingularityTaskId() {
        return SingularityTaskId.valueOf((String)this.taskDefinition.getTaskId());
    }

    public Path getLogrotateConfPath() {
        return Paths.get(this.configuration.getLogrotateConfDirectory(), new String[0]).resolve(this.taskDefinition.getTaskId());
    }

    public Path getLogrotateHourlyConfPath() {
        return Paths.get(this.configuration.getLogrotateHourlyConfDirectory(), new String[0]).resolve(this.taskDefinition.getTaskId());
    }

    public Path getLogrotateSizeBasedConfPath() {
        return Paths.get(this.configuration.getLogrotateHourlyConfDirectory(), new String[0]).resolve(this.taskDefinition.getTaskId() + ".sizebased");
    }

    public Path getLogrotateCronPath() {
        return Paths.get(this.configuration.getCronDirectory(), new String[0]).resolve(this.taskDefinition.getTaskId() + ".logrotate");
    }

    private boolean writeS3MetadataFile(String filenameHint, Path pathToS3Directory, String globForS3Files, Optional<String> s3Bucket, Optional<String> s3KeyPattern, boolean finished, Optional<String> s3StorageClass, Optional<Long> applyS3StorageClassAfterBytes, boolean checkSubdirectories) {
        String s3UploaderBucket = s3Bucket.orElse(this.taskDefinition.getExecutorData().getDefaultS3Bucket());
        if (Strings.isNullOrEmpty((String)s3UploaderBucket)) {
            this.log.warn("No s3 bucket specified, not writing s3 metadata for file matcher {}", (Object)globForS3Files);
            return false;
        }
        S3UploadMetadata s3UploadMetadata = new S3UploadMetadata(pathToS3Directory.toString(), globForS3Files, s3UploaderBucket, this.getS3KeyPattern(s3KeyPattern.orElse(this.taskDefinition.getExecutorData().getS3UploaderKeyPattern())), finished, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), s3StorageClass, applyS3StorageClassAfterBytes, Optional.of(finished), Optional.of(checkSubdirectories), Optional.empty(), Collections.emptyMap(), Optional.empty(), Optional.empty(), Optional.empty());
        String s3UploadMetadataFileName = String.format("%s-%s%s", this.taskDefinition.getTaskId(), filenameHint, this.baseConfiguration.getS3UploaderMetadataSuffix());
        Path s3UploadMetadataPath = Paths.get(this.baseConfiguration.getS3UploaderMetadataDirectory(), new String[0]).resolve(s3UploadMetadataFileName);
        return this.jsonObjectFileHelper.writeObject((Object)s3UploadMetadata, s3UploadMetadataPath, this.log);
    }
}

