/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.deploy.HealthcheckOptions;
import com.hubspot.singularity.SingularityTaskExecutorData;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class SingularityExecutorTaskDefinition {
    private final SingularityTaskExecutorData executorData;
    private final String taskId;
    private final Path taskDirectoryPath;
    private final String executorBashOut;
    private final String serviceLogOut;
    private final String serviceLogOutExtension;
    private final String serviceFinishedTailLog;
    private final String taskAppDirectory;
    private final String logrotateStateFile;
    private final String executorPid;
    private final String signatureVerifyOut;

    @JsonCreator
    public SingularityExecutorTaskDefinition(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="executorData") SingularityTaskExecutorData executorData, @JsonProperty(value="taskDirectory") String taskDirectory, @JsonProperty(value="executorPid") String executorPid, @JsonProperty(value="serviceLogOut") String serviceLogOut, @JsonProperty(value="serviceLogOutExtension") String serviceLogOutExtension, @JsonProperty(value="serviceFinishedTailLog") String serviceFinishedTailLog, @JsonProperty(value="taskAppDirectory") String taskAppDirectory, @JsonProperty(value="executorBashOut") String executorBashOut, @JsonProperty(value="logrotateStateFilePath") String logrotateStateFile, @JsonProperty(value="signatureVerifyOut") String signatureVerifyOut) {
        this.executorData = executorData;
        this.taskId = taskId;
        this.taskDirectoryPath = Paths.get(taskDirectory, new String[0]);
        this.executorPid = executorPid;
        this.executorBashOut = executorBashOut;
        this.serviceLogOut = serviceLogOut;
        this.serviceLogOutExtension = serviceLogOutExtension;
        this.serviceFinishedTailLog = serviceFinishedTailLog;
        this.taskAppDirectory = taskAppDirectory;
        this.logrotateStateFile = logrotateStateFile;
        this.signatureVerifyOut = signatureVerifyOut;
    }

    @JsonIgnore
    public Path getTaskDirectoryPath() {
        return this.taskDirectoryPath;
    }

    @JsonIgnore
    public Path getExecutorBashOutPath() {
        return this.taskDirectoryPath.resolve(this.executorBashOut);
    }

    @JsonIgnore
    public Path getServiceLogOutPath() {
        return this.taskDirectoryPath.resolve(this.serviceLogOut);
    }

    @JsonIgnore
    public Path getTaskAppDirectoryPath() {
        return this.taskDirectoryPath.resolve(this.taskAppDirectory);
    }

    @JsonIgnore
    public Path getLogrotateStateFilePath() {
        return this.taskDirectoryPath.resolve(this.logrotateStateFile);
    }

    @JsonIgnore
    public boolean shouldLogrotateLogFile() {
        return this.executorData.getSkipLogrotateAndCompress().orElse(Boolean.FALSE) == false;
    }

    @JsonIgnore
    public Path getSignatureVerifyOutPath() {
        return this.taskDirectoryPath.resolve(this.signatureVerifyOut);
    }

    public String getTaskDirectory() {
        return this.taskDirectoryPath.toString();
    }

    public String getExecutorBashOut() {
        return this.getExecutorBashOutPath().toString();
    }

    public String getServiceLogOut() {
        return this.getServiceLogOutPath().toString();
    }

    @JsonIgnore
    public String getServiceLogFileName() {
        return this.serviceLogOut;
    }

    @JsonIgnore
    public String getServiceFinishedTailLogFileName() {
        return this.serviceFinishedTailLog;
    }

    public String getServiceLogOutExtension() {
        return this.serviceLogOutExtension;
    }

    public String getServiceFinishedTailLog() {
        return this.getServiceFinishedTailLogPath().toString();
    }

    @JsonIgnore
    public Path getServiceFinishedTailLogPath() {
        return this.taskDirectoryPath.resolve(this.serviceFinishedTailLog);
    }

    public String getTaskAppDirectory() {
        return this.getTaskAppDirectoryPath().toString();
    }

    public String getLogrotateStateFile() {
        return this.getLogrotateStateFilePath().toString();
    }

    public SingularityTaskExecutorData getExecutorData() {
        return this.executorData;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getExecutorPid() {
        return this.executorPid;
    }

    public String getSignatureVerifyOut() {
        return this.signatureVerifyOut;
    }

    public Optional<String> getHealthcheckResultFilePath() {
        if (this.executorData.getHealthcheckOptions().isPresent()) {
            return ((HealthcheckOptions)this.executorData.getHealthcheckOptions().get()).getHealthcheckResultFilePath();
        }
        return Optional.empty();
    }

    public Optional<HealthcheckOptions> getHealthcheckOptions() {
        return this.executorData.getHealthcheckOptions();
    }

    @JsonIgnore
    public Optional<Integer> getExecutorPidSafe() {
        try {
            return Optional.of(Integer.parseInt(this.executorPid));
        }
        catch (NumberFormatException nfe) {
            return Optional.empty();
        }
    }

    public String toString() {
        return "SingularityExecutorTaskDefinition{executorData=" + this.executorData + ", taskId='" + this.taskId + '\'' + ", taskDirectoryPath=" + this.taskDirectoryPath + ", executorBashOut='" + this.executorBashOut + '\'' + ", serviceLogOut='" + this.serviceLogOut + '\'' + ", serviceLogOutExtension='" + this.serviceLogOutExtension + '\'' + ", serviceFinishedTailLog='" + this.serviceFinishedTailLog + '\'' + ", taskAppDirectory='" + this.taskAppDirectory + '\'' + ", logrotateStateFile='" + this.logrotateStateFile + '\'' + ", executorPid='" + this.executorPid + '\'' + ", signatureVerifyOut='" + this.signatureVerifyOut + '\'' + '}';
    }
}

