/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.google.common.collect.ImmutableList;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.config.SingularityExecutorLogrotateAdditionalFile;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskLogManager;
import com.hubspot.singularity.executor.task.TaskCleanupResult;
import com.hubspot.singularity.executor.utils.DockerUtils;
import com.hubspot.singularity.runner.base.shared.ExceptionChainParser;
import com.hubspot.singularity.runner.base.shared.SimpleProcessManager;
import com.spotify.docker.client.exceptions.ContainerNotFoundException;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class SingularityExecutorTaskCleanup {
    private final SingularityExecutorTaskDefinition taskDefinition;
    private final SingularityExecutorTaskLogManager taskLogManager;
    private final SingularityExecutorConfiguration configuration;
    private final Logger log;
    private final DockerUtils dockerUtils;

    public SingularityExecutorTaskCleanup(SingularityExecutorTaskLogManager taskLogManager, SingularityExecutorConfiguration configuration, SingularityExecutorTaskDefinition taskDefinition, Logger log, DockerUtils dockerUtils) {
        this.configuration = configuration;
        this.taskLogManager = taskLogManager;
        this.taskDefinition = taskDefinition;
        this.log = log;
        this.dockerUtils = dockerUtils;
    }

    public TaskCleanupResult cleanup(boolean cleanupTaskAppDirectory, boolean cleanupLogs, boolean isDocker) {
        Path taskDirectory = Paths.get(this.taskDefinition.getTaskDirectory(), new String[0]);
        boolean dockerCleanSuccess = true;
        if (isDocker) {
            try {
                String containerName = String.format("%s%s", this.configuration.getDockerPrefix(), this.taskDefinition.getTaskId());
                ContainerInfo containerInfo = this.dockerUtils.inspectContainer(containerName);
                if (containerInfo.state().running().booleanValue()) {
                    this.dockerUtils.stopContainer(containerName, this.configuration.getDockerStopTimeout());
                }
                this.dockerUtils.removeContainer(containerName, true);
            }
            catch (DockerException e) {
                if (ExceptionChainParser.exceptionChainContains((Exception)((Object)e), ContainerNotFoundException.class)) {
                    this.log.trace("Container for task {} was already removed", (Object)this.taskDefinition.getTaskId());
                } else {
                    this.log.error("Could not ensure removal of container", (Throwable)e);
                    dockerCleanSuccess = false;
                }
            }
            catch (Exception e) {
                this.log.error("Could not ensure removal of container", (Throwable)e);
                dockerCleanSuccess = false;
            }
        }
        if (!Files.exists(taskDirectory, new LinkOption[0])) {
            this.log.info("Directory {} didn't exist for cleanup", (Object)taskDirectory);
            this.taskLogManager.removeLogrotateFile();
            return this.finishTaskCleanup(dockerCleanSuccess);
        }
        boolean logTearDownSuccess = this.taskLogManager.teardown();
        this.log.info("Rotated and marked logs for upload for {} ({})", (Object)taskDirectory, (Object)logTearDownSuccess);
        if (!cleanupLogs) {
            this.log.debug("Not finishing cleanup because log files will be preserved for 15 minutes after task termination");
            return TaskCleanupResult.WAITING;
        }
        boolean rotatedLogfileDeleteSuccess = this.checkForLogrotateAdditionalFilesToDelete(this.taskDefinition);
        this.log.info("Deleted rotated logfiles ({})", (Object)rotatedLogfileDeleteSuccess);
        if (!cleanupTaskAppDirectory) {
            this.log.debug("Not finishing cleanup because taskApp directory is being preserved");
            return TaskCleanupResult.WAITING;
        }
        boolean cleanupTaskAppDirectorySuccess = this.cleanupTaskAppDirectory();
        this.log.info("Cleaned up task app directory ({})", (Object)cleanupTaskAppDirectorySuccess);
        if (logTearDownSuccess && cleanupTaskAppDirectorySuccess) {
            return this.finishTaskCleanup(dockerCleanSuccess);
        }
        return TaskCleanupResult.ERROR;
    }

    private TaskCleanupResult finishTaskCleanup(boolean dockerCleanSuccess) {
        boolean cleanTaskDefinitionFile = this.cleanTaskDefinitionFile();
        if (cleanTaskDefinitionFile && dockerCleanSuccess) {
            return TaskCleanupResult.SUCCESS;
        }
        return TaskCleanupResult.ERROR;
    }

    public boolean cleanTaskDefinitionFile() {
        Path taskDefinitionPath = this.configuration.getTaskDefinitionPath(this.taskDefinition.getTaskId());
        this.log.debug("Successful cleanup, deleting file {}", (Object)taskDefinitionPath);
        try {
            boolean deleted = Files.deleteIfExists(taskDefinitionPath);
            this.log.debug("File deleted ({})", (Object)deleted);
            return true;
        }
        catch (IOException e) {
            this.log.error("Failed deleting {}", (Object)taskDefinitionPath, (Object)e);
            return false;
        }
    }

    private boolean cleanupTaskAppDirectory() {
        String pathToDelete = this.taskDefinition.getTaskAppDirectory();
        this.log.debug("Deleting: {}", (Object)pathToDelete);
        try {
            ImmutableList cmd = ImmutableList.of((Object)"rm", (Object)"-rf", (Object)pathToDelete);
            new SimpleProcessManager(this.log).runCommand((List)cmd);
            return true;
        }
        catch (Throwable t) {
            this.log.error("While deleting directory {}", (Object)pathToDelete, (Object)t);
            return false;
        }
    }

    private boolean checkForLogrotateAdditionalFilesToDelete(SingularityExecutorTaskDefinition taskDefinition) {
        return this.configuration.getLogrotateAdditionalFiles().stream().filter(SingularityExecutorLogrotateAdditionalFile::isDeleteInExecutorCleanup).allMatch(toDelete -> {
            String glob = String.format("glob:%s/%s", taskDefinition.getTaskDirectoryPath().toAbsolutePath(), toDelete.getFilename());
            this.log.debug("Trying to delete {} for task {} using glob {}...", new Object[]{toDelete.getFilename(), taskDefinition.getTaskId(), glob});
            try {
                List<Path> matches = this.findGlob(taskDefinition.getTaskDirectoryPath().toAbsolutePath(), taskDefinition.getTaskDirectoryPath().getFileSystem().getPathMatcher(glob));
                for (Path match : matches) {
                    Files.delete(match);
                    this.log.debug("Deleted {}", (Object)match);
                }
                return true;
            }
            catch (IOException e) {
                this.log.error("Unable to list files while trying to delete for {}", toDelete);
                return false;
            }
        });
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="https://github.com/spotbugs/spotbugs/issues/259")
    private List<Path> findGlob(Path path, PathMatcher matcher) throws IOException {
        ArrayDeque<Path> stack = new ArrayDeque<Path>();
        ArrayList<Path> matched = new ArrayList<Path>();
        stack.push(path);
        while (!stack.isEmpty()) {
            DirectoryStream<Path> stream = Files.newDirectoryStream((Path)stack.pop());
            Throwable throwable = null;
            try {
                for (Path entry : stream) {
                    if (Files.isDirectory(entry, new LinkOption[0])) {
                        stack.push(entry);
                        continue;
                    }
                    if (!matcher.matches(entry)) continue;
                    matched.add(entry);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return matched;
    }
}

