/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.hubspot.deploy.S3Artifact;
import com.hubspot.deploy.S3ArtifactSignature;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.task.ArtifactVerificationException;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import com.hubspot.singularity.s3.base.config.SingularityS3Configuration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;

public class SingularityExecutorArtifactVerifier {
    private final Logger log;
    private final SingularityExecutorConfiguration executorConfiguration;
    private final SingularityExecutorTaskDefinition taskDefinition;
    private final SingularityS3Configuration s3Configuration;

    public SingularityExecutorArtifactVerifier(SingularityExecutorTaskDefinition taskDefinition, Logger log, SingularityExecutorConfiguration executorConfiguration, SingularityS3Configuration s3Configuration) {
        this.log = log;
        this.executorConfiguration = executorConfiguration;
        this.taskDefinition = taskDefinition;
        this.s3Configuration = s3Configuration;
    }

    public void checkSignatures(List<S3Artifact> s3Artifacts, List<S3ArtifactSignature> s3ArtifactsWithSignatures) {
        if (s3ArtifactsWithSignatures.isEmpty()) {
            this.log.info("No files containing artifact signatures specified, skipping verification.");
            return;
        }
        for (S3ArtifactSignature s3ArtifactSignature : s3ArtifactsWithSignatures) {
            Optional<S3Artifact> maybeMatchingForSignature = s3Artifacts.stream().filter(s -> s3ArtifactSignature.getArtifactFilename().equals(s.getFilename())).findFirst();
            if (maybeMatchingForSignature.isPresent()) {
                this.checkArtifactSignature(maybeMatchingForSignature.get(), s3ArtifactSignature);
                continue;
            }
            this.log.warn("No matching artifact found for signature {}", (Object)s3ArtifactSignature);
            if (!this.executorConfiguration.isFailOnSignatureWithNoMatchingArtifact()) continue;
            throw new ArtifactVerificationException(String.format("No matching artifact found for signature %s", s3ArtifactSignature.getFilename()));
        }
    }

    private void checkArtifactSignature(S3Artifact s3Artifact, S3ArtifactSignature s3ArtifactSignature) {
        Path artifactPath = Paths.get(this.s3Configuration.getArtifactCacheDirectory(), s3Artifact.getFilenameForCache());
        Path artifactSignaturePath = Paths.get(this.s3Configuration.getArtifactCacheDirectory(), s3ArtifactSignature.getFilenameForCache());
        if (!Files.exists(artifactPath, new LinkOption[0])) {
            this.log.warn("Artifact {} not found for signature {}", (Object)artifactPath, (Object)s3ArtifactSignature);
            return;
        }
        ArrayList<String> verifyCommand = new ArrayList<String>(this.executorConfiguration.getArtifactSignatureVerificationCommand().size());
        for (String arg : this.executorConfiguration.getArtifactSignatureVerificationCommand()) {
            verifyCommand.add(arg.replace("{artifactPath}", artifactPath.toString()).replace("{artifactSignaturePath}", artifactSignaturePath.toString()));
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(verifyCommand);
            processBuilder.directory(this.taskDefinition.getTaskDirectoryPath().toFile());
            processBuilder.redirectError(this.taskDefinition.getSignatureVerifyOutPath().toFile());
            processBuilder.redirectOutput(this.taskDefinition.getSignatureVerifyOutPath().toFile());
            Process p = processBuilder.start();
            p.waitFor();
            if (p.exitValue() != 0) {
                this.log.error("Failed to validate signature in file {} for artifact file {}", (Object)s3ArtifactSignature.getFilename(), (Object)s3ArtifactSignature.getArtifactFilename());
                if (this.executorConfiguration.isFailTaskOnInvalidArtifactSignature()) {
                    throw new ArtifactVerificationException(String.format("Failed to validate signature for artifact %s", artifactPath));
                }
            } else {
                this.log.info("Signature in {} for artifact {} is valid!", (Object)s3ArtifactSignature.getFilename(), (Object)s3ArtifactSignature.getArtifactFilename());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

