/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.hubspot.deploy.Artifact;
import com.hubspot.deploy.S3Artifact;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.task.LocalDownloadServiceFetcher;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.s3.base.ArtifactDownloadRequest;
import com.hubspot.singularity.s3.base.config.SingularityS3Configuration;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class HttpLocalDownloadServiceFetcher
implements LocalDownloadServiceFetcher {
    private static final String LOCAL_DOWNLOAD_STRING_FORMAT = "http://localhost:%s%s";
    private final AsyncHttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final SingularityExecutorConfiguration executorConfiguration;
    private final String localDownloadUri;

    public HttpLocalDownloadServiceFetcher(AsyncHttpClient httpClient, ObjectMapper objectMapper, SingularityExecutorConfiguration executorConfiguration, SingularityS3Configuration s3Configuration) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.executorConfiguration = executorConfiguration;
        this.localDownloadUri = String.format(LOCAL_DOWNLOAD_STRING_FORMAT, s3Configuration.getLocalDownloadHttpPort(), s3Configuration.getLocalDownloadPath());
    }

    @Override
    public String getDownloadPath() {
        return this.localDownloadUri;
    }

    @Override
    public void downloadFiles(List<? extends S3Artifact> s3Artifacts, SingularityExecutorTask task) throws InterruptedException {
        ArrayList futures = Lists.newArrayListWithCapacity((int)s3Artifacts.size());
        for (S3Artifact s3Artifact : s3Artifacts) {
            String destination = task.getArtifactPath((Artifact)s3Artifact, task.getTaskDefinition().getTaskDirectoryPath()).toString();
            ArtifactDownloadRequest artifactDownloadRequest = new ArtifactDownloadRequest(destination, s3Artifact, Optional.of(this.executorConfiguration.getLocalDownloadServiceTimeoutMillis()));
            task.getLog().debug("Requesting {} from {}", (Object)artifactDownloadRequest, (Object)this.localDownloadUri);
            AsyncHttpClient.BoundRequestBuilder postRequestBldr = this.httpClient.preparePost(this.localDownloadUri);
            try {
                postRequestBldr.setBody(this.objectMapper.writeValueAsBytes((Object)artifactDownloadRequest));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            try {
                ListenableFuture future = this.httpClient.executeRequest(postRequestBldr.build());
                futures.add(new FutureHolder((ListenableFuture<Response>)future, System.currentTimeMillis(), s3Artifact));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        for (FutureHolder futureHolder : futures) {
            Response response = futureHolder.getResponse();
            task.getLog().debug("Future for {} got status code {} after {}", new Object[]{futureHolder.s3Artifact.getName(), response.getStatusCode(), JavaUtils.duration((long)futureHolder.start)});
            if (response.getStatusCode() == 200) continue;
            throw new IllegalStateException("Got status code:" + response.getStatusCode());
        }
    }

    private static class FutureHolder {
        private final ListenableFuture<Response> future;
        private final long start;
        private final S3Artifact s3Artifact;

        public FutureHolder(ListenableFuture<Response> future, long start, S3Artifact s3Artifact) {
            this.future = future;
            this.start = start;
            this.s3Artifact = s3Artifact;
        }

        public Response getResponse() throws InterruptedException {
            try {
                return (Response)this.future.get();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

