/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.models;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.hubspot.singularity.executor.SingularityExecutorLogrotateFrequency;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.config.SingularityExecutorLogrotateAdditionalFile;
import com.hubspot.singularity.executor.models.LogrotateAdditionalFile;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class LogrotateTemplateContext {
    private static final Predicate<LogrotateAdditionalFile> BELONGS_IN_HOURLY_CRON_FORCED_LOGROTATE_CONF = p -> p.getLogrotateFrequencyOverride().equals(SingularityExecutorLogrotateFrequency.HOURLY.getLogrotateValue());
    private static final Predicate<LogrotateAdditionalFile> BELONGS_IN_SIZE_BASED_LOGROTATE_CONF = p -> p.getLogrotateSizeOverride() != null && !p.getLogrotateSizeOverride().isEmpty();
    private final SingularityExecutorTaskDefinition taskDefinition;
    private final SingularityExecutorConfiguration configuration;

    public LogrotateTemplateContext(SingularityExecutorConfiguration configuration, SingularityExecutorTaskDefinition taskDefinition) {
        this.configuration = configuration;
        this.taskDefinition = taskDefinition;
    }

    public String getRotateDateformat() {
        return this.configuration.getLogrotateDateformat().startsWith("-") ? this.configuration.getLogrotateDateformat().substring(1) : this.configuration.getLogrotateDateformat();
    }

    public int getRotateCount() {
        return this.configuration.getLogrotateCount();
    }

    public int getMaxageDays() {
        return this.configuration.getLogrotateMaxageDays();
    }

    public String getRotateDirectory() {
        return this.configuration.getLogrotateToDirectory();
    }

    public boolean getShouldLogRotateLogFile() {
        return this.taskDefinition.shouldLogrotateLogFile();
    }

    public String getTaskDirectory() {
        return this.taskDefinition.getTaskDirectoryPath().toString();
    }

    public String getLogrotateFrequency() {
        return this.taskDefinition.getExecutorData().getLogrotateFrequency().orElse(this.configuration.getLogrotateFrequency()).getLogrotateValue();
    }

    public String getCompressCmd() {
        return this.configuration.getLogrotateCompressionSettings().getCompressCmd().orElse(null);
    }

    public String getUncompressCmd() {
        return this.configuration.getLogrotateCompressionSettings().getUncompressCmd().orElse(null);
    }

    public String getCompressOptions() {
        return this.configuration.getLogrotateCompressionSettings().getCompressOptions().orElse(null);
    }

    public String getCompressExt() {
        return this.configuration.getLogrotateCompressionSettings().getCompressExt().orElse(null);
    }

    public List<LogrotateAdditionalFile> getExtrasFiles() {
        return this.getAllExtraFiles().stream().filter(BELONGS_IN_HOURLY_CRON_FORCED_LOGROTATE_CONF.negate().and(BELONGS_IN_SIZE_BASED_LOGROTATE_CONF.negate())).collect(Collectors.toList());
    }

    public List<LogrotateAdditionalFile> getExtrasFilesHourly() {
        return this.getAllExtraFiles().stream().filter(BELONGS_IN_HOURLY_CRON_FORCED_LOGROTATE_CONF).collect(Collectors.toList());
    }

    public List<LogrotateAdditionalFile> getExtrasFilesSizeBased() {
        return this.getAllExtraFiles().stream().filter(BELONGS_IN_SIZE_BASED_LOGROTATE_CONF).collect(Collectors.toList());
    }

    public boolean isGlobalLogrotateHourly() {
        return this.configuration.getLogrotateFrequency().getLogrotateValue().equals(SingularityExecutorLogrotateFrequency.HOURLY.getLogrotateValue());
    }

    private List<LogrotateAdditionalFile> getAllExtraFiles() {
        List<SingularityExecutorLogrotateAdditionalFile> original = this.configuration.getLogrotateAdditionalFiles();
        ArrayList<LogrotateAdditionalFile> transformed = new ArrayList<LogrotateAdditionalFile>(original.size());
        for (SingularityExecutorLogrotateAdditionalFile additionalFile : original) {
            String dateformat = additionalFile.getDateformat().isPresent() ? (additionalFile.getDateformat().get().startsWith("-") ? additionalFile.getDateformat().get().substring(1) : additionalFile.getDateformat().get()) : (this.configuration.getLogrotateExtrasDateformat().startsWith("-") ? this.configuration.getLogrotateExtrasDateformat().substring(1) : this.configuration.getLogrotateExtrasDateformat());
            transformed.add(new LogrotateAdditionalFile(this.taskDefinition.getTaskDirectoryPath().resolve(additionalFile.getFilename()).toString(), additionalFile.getExtension().isPresent() ? additionalFile.getExtension().get() : Strings.emptyToNull((String)Files.getFileExtension((String)additionalFile.getFilename())), dateformat, additionalFile.getLogrotateFrequencyOverride(), additionalFile.getLogrotateSizeOverride()));
        }
        return transformed;
    }

    private Optional<String> parseFilenameExtension(String filename) {
        int lastPeriodIndex = filename.lastIndexOf(46);
        if (lastPeriodIndex > -1 && !filename.substring(lastPeriodIndex + 1).contains("*")) {
            return Optional.of(filename.substring(lastPeriodIndex + 1));
        }
        return Optional.empty();
    }

    public String getExtrasDateformat() {
        return this.configuration.getLogrotateExtrasDateformat();
    }

    public String getLogfile() {
        return this.taskDefinition.getServiceLogOut();
    }

    public String getLogfileExtension() {
        return this.taskDefinition.getServiceLogOutExtension();
    }

    public String getLogfileName() {
        return this.taskDefinition.getServiceLogFileName();
    }

    public boolean isUseFileAttributes() {
        return this.configuration.isUseFileAttributes();
    }

    public String toString() {
        return "LogrotateTemplateContext{taskDefinition=" + this.taskDefinition + ", configuration=" + (Object)((Object)this.configuration) + '}';
    }
}

