/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.models;

import com.hubspot.singularity.executor.models.EnvironmentContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.mesos.Protos;

public class DockerEnvironmentContext
extends EnvironmentContext {
    private final List<String> inheritVariables;

    public DockerEnvironmentContext(Protos.TaskInfo taskInfo, List<String> inheritVariables) {
        super(taskInfo);
        this.inheritVariables = inheritVariables;
    }

    @Override
    public List<Protos.Environment.Variable> getEnv() {
        ArrayList<Protos.Environment.Variable> variables = new ArrayList<Protos.Environment.Variable>();
        HashSet keys = new HashSet();
        this.inheritVariables.forEach(v -> {
            String val;
            if (!keys.contains(v) && (val = System.getenv(v)) != null) {
                variables.add(Protos.Environment.Variable.newBuilder().setName(v).setValue(val).build());
                keys.add(v);
            }
        });
        this.taskInfo.getExecutor().getCommand().getEnvironment().getVariablesList().forEach(v -> {
            if (!keys.contains(v.getName())) {
                variables.add((Protos.Environment.Variable)v);
                keys.add(v.getName());
            }
        });
        return variables;
    }
}

