/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.hubspot.singularity.SingularityTaskExecutorData;
import com.hubspot.singularity.executor.TemplateManager;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.config.SingularityExecutorLogging;
import com.hubspot.singularity.executor.task.SingularityExecutorArtifactFetcher;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import com.hubspot.singularity.executor.utils.DockerUtils;
import com.hubspot.singularity.executor.utils.ExecutorUtils;
import com.hubspot.singularity.executor.utils.MesosUtils;
import com.hubspot.singularity.runner.base.configuration.SingularityRunnerBaseConfiguration;
import com.hubspot.singularity.runner.base.shared.JsonObjectFileHelper;
import com.hubspot.singularity.s3.base.config.SingularityS3Configuration;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Path;
import java.util.stream.Collectors;
import org.apache.mesos.ExecutorDriver;
import org.apache.mesos.Protos;
import org.slf4j.Logger;

@Singleton
public class SingularityExecutorTaskBuilder {
    private final ObjectMapper jsonObjectMapper;
    private final TemplateManager templateManager;
    private final SingularityRunnerBaseConfiguration baseConfiguration;
    private final SingularityExecutorConfiguration executorConfiguration;
    private final SingularityExecutorArtifactFetcher artifactFetcher;
    private final DockerUtils dockerUtils;
    private final SingularityS3Configuration s3Configuration;
    private final SingularityExecutorLogging executorLogging;
    private final ExecutorUtils executorUtils;
    private final String executorPid;
    private final JsonObjectFileHelper jsonObjectFileHelper;

    @Inject
    public SingularityExecutorTaskBuilder(ObjectMapper jsonObjectMapper, JsonObjectFileHelper jsonObjectFileHelper, TemplateManager templateManager, SingularityExecutorLogging executorLogging, SingularityRunnerBaseConfiguration baseConfiguration, SingularityExecutorConfiguration executorConfiguration, @Named(value="process.name") String executorPid, ExecutorUtils executorUtils, SingularityExecutorArtifactFetcher artifactFetcher, DockerUtils dockerUtils, SingularityS3Configuration s3Configuration) {
        this.jsonObjectFileHelper = jsonObjectFileHelper;
        this.jsonObjectMapper = jsonObjectMapper;
        this.templateManager = templateManager;
        this.executorLogging = executorLogging;
        this.baseConfiguration = baseConfiguration;
        this.executorConfiguration = executorConfiguration;
        this.artifactFetcher = artifactFetcher;
        this.dockerUtils = dockerUtils;
        this.executorPid = executorPid;
        this.executorUtils = executorUtils;
        this.s3Configuration = s3Configuration;
    }

    public ch.qos.logback.classic.Logger buildTaskLogger(String taskId, String executorId) {
        Path javaExecutorLogPath = MesosUtils.getTaskDirectoryPath(taskId).resolve(this.executorConfiguration.getExecutorJavaLog());
        return this.executorLogging.buildTaskLogger(taskId, executorId, this.executorPid, javaExecutorLogPath.toString());
    }

    public SingularityExecutorTask buildTask(String taskId, ExecutorDriver driver, Protos.TaskInfo taskInfo, ch.qos.logback.classic.Logger log) {
        SingularityTaskExecutorData taskExecutorData = this.readExecutorData(this.jsonObjectMapper, taskInfo);
        if (this.executorConfiguration.isVerifyAssignedPorts()) {
            this.checkAssignedPorts(taskInfo);
        }
        SingularityExecutorTaskDefinition taskDefinition = new SingularityExecutorTaskDefinition(taskId, taskExecutorData, MesosUtils.getTaskDirectoryPath(taskId).toString(), this.executorPid, taskExecutorData.getServiceLog(), Files.getFileExtension((String)taskExecutorData.getServiceLog()), taskExecutorData.getServiceFinishedTailLog(), this.executorConfiguration.getTaskAppDirectory(), this.executorConfiguration.getExecutorBashLog(), this.executorConfiguration.getLogrotateStateFile(), this.executorConfiguration.getSignatureVerifyOut());
        this.jsonObjectFileHelper.writeObject((Object)taskDefinition, this.executorConfiguration.getTaskDefinitionPath(taskId), (Logger)log);
        return new SingularityExecutorTask(driver, this.executorUtils, this.baseConfiguration, this.executorConfiguration, taskDefinition, this.executorPid, this.artifactFetcher, taskInfo, this.templateManager, log, this.jsonObjectFileHelper, this.dockerUtils, this.jsonObjectMapper, this.s3Configuration);
    }

    private void checkAssignedPorts(Protos.TaskInfo taskInfo) {
        for (Protos.Resource portsResource : taskInfo.getResourcesList().stream().filter(r -> r.getName().equals("ports")).collect(Collectors.toList())) {
            for (Protos.Value.Range r2 : portsResource.getRanges().getRangeList()) {
                for (long port = r2.getBegin(); port <= r2.getEnd(); ++port) {
                    if (!this.isPortInUse((int)port)) continue;
                    throw new RuntimeException(String.format("Assigned port %d was already in use", port));
                }
            }
        }
    }

    private boolean isPortInUse(int port) {
        try {
            new ServerSocket(port, 1).close();
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    private SingularityTaskExecutorData readExecutorData(ObjectMapper objectMapper, Protos.TaskInfo taskInfo) {
        try {
            Preconditions.checkState((boolean)taskInfo.hasData(), (Object)"TaskInfo was missing executor data");
            return (SingularityTaskExecutorData)objectMapper.readValue(taskInfo.getData().toByteArray(), SingularityTaskExecutorData.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

