/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.hubspot.singularity.SingularityFrameworkMessage;
import com.hubspot.singularity.SingularityTaskDestroyFrameworkMessage;
import com.hubspot.singularity.SingularityTaskShellCommandRequest;
import com.hubspot.singularity.SingularityTaskShellCommandUpdate;
import com.hubspot.singularity.executor.SingularityExecutorMonitor;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.shells.SingularityExecutorShellCommandRunner;
import com.hubspot.singularity.executor.shells.SingularityExecutorShellCommandUpdater;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskProcessCallable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingularityExecutorMesosFrameworkMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SingularityExecutorMesosFrameworkMessageHandler.class);
    private final SingularityExecutorMonitor monitor;
    private final SingularityExecutorConfiguration executorConfiguration;
    private final ObjectMapper objectMapper;

    @Inject
    public SingularityExecutorMesosFrameworkMessageHandler(ObjectMapper objectMapper, SingularityExecutorMonitor monitor, SingularityExecutorConfiguration executorConfiguration) {
        this.objectMapper = objectMapper;
        this.monitor = monitor;
        this.executorConfiguration = executorConfiguration;
    }

    public void handleMessage(byte[] data) {
        block4: {
            try {
                SingularityFrameworkMessage message = (SingularityFrameworkMessage)this.objectMapper.readValue(data, SingularityFrameworkMessage.class);
                if (message.getClass().equals(SingularityTaskShellCommandRequest.class)) {
                    this.handleShellRequest((SingularityTaskShellCommandRequest)message);
                    break block4;
                }
                if (message.getClass().equals(SingularityTaskDestroyFrameworkMessage.class)) {
                    this.handleTaskDestroyMessage((SingularityTaskDestroyFrameworkMessage)message);
                    break block4;
                }
                throw new IOException(String.format("Do not know how to handle framework message of class %s", message.getClass()));
            }
            catch (IOException e) {
                LOG.error("Do not know how to handle framework message {}", (Object)new String(data, StandardCharsets.UTF_8), (Object)e);
            }
        }
    }

    private void handleTaskDestroyMessage(SingularityTaskDestroyFrameworkMessage taskDestroyMessage) {
        SingularityExecutorMonitor.KillState killState = this.monitor.requestKill(taskDestroyMessage.getTaskId().getId(), taskDestroyMessage.getUser(), true);
        switch (killState) {
            case DIDNT_EXIST: 
            case INCONSISTENT_STATE: {
                LOG.warn("Couldn't destroy task {} due to killState {}", (Object)taskDestroyMessage.getTaskId(), (Object)killState);
                break;
            }
            case DESTROYING_PROCESS: 
            case INTERRUPTING_PRE_PROCESS: 
            case KILLING_PROCESS: {
                LOG.info("Requested destroy of task {} with killState {}", (Object)taskDestroyMessage.getTaskId(), (Object)killState);
            }
        }
    }

    private void handleShellRequest(SingularityTaskShellCommandRequest shellRequest) {
        Optional<SingularityExecutorTask> matchingTask = this.monitor.getTask(shellRequest.getTaskId().getId());
        if (!matchingTask.isPresent()) {
            LOG.warn("Missing task for {}, ignoring shell request", (Object)shellRequest.getTaskId());
            return;
        }
        matchingTask.get().getLog().info("Received shell request {}", (Object)shellRequest);
        SingularityExecutorShellCommandUpdater updater = new SingularityExecutorShellCommandUpdater(this.objectMapper, shellRequest, matchingTask.get());
        Optional<SingularityExecutorTaskProcessCallable> taskProcess = this.monitor.getTaskProcess(shellRequest.getTaskId().getId());
        if (!taskProcess.isPresent()) {
            updater.sendUpdate(SingularityTaskShellCommandUpdate.UpdateType.INVALID, Optional.of("No task process found"), Optional.empty());
            return;
        }
        SingularityExecutorShellCommandRunner shellRunner = new SingularityExecutorShellCommandRunner(shellRequest, this.executorConfiguration, matchingTask.get(), taskProcess.get(), this.monitor.getShellCommandExecutorServiceForTask(shellRequest.getTaskId().getId()), updater);
        shellRunner.start();
    }
}

