/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor;

import com.google.common.collect.ImmutableList;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.runner.base.shared.ProcessFailedException;
import com.hubspot.singularity.runner.base.shared.SimpleProcessManager;
import com.hubspot.singularity.runner.base.shared.WatchServiceHelper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingularityExecutorCgroupCfsChecker
extends WatchServiceHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SingularityExecutorCgroupCfsChecker.class);
    private static final List<String> FIND_BASE_CGROUP_PATH_COMMAND = ImmutableList.of((Object)"findmnt", (Object)"--kernel", (Object)"--first-only", (Object)"--types", (Object)"cgroup", (Object)"--options", (Object)"cpu", (Object)"--noheadings", (Object)"--output", (Object)"TARGET");
    private static final String CGROUP_CFS_QUOTA_FILE = "cpu.cfs_quota_us";
    private static final String CGROUP_CFS_PERIOD_FILE = "cpu.cfs_period_us";
    private final String taskId;
    private final long desiredCfsQuota;
    private final long desiredCfsPeriod;

    public SingularityExecutorCgroupCfsChecker(SingularityExecutorTask task, int cpuHardLimit, long desiredCfsPeriod) throws IOException, InterruptedException, ProcessFailedException {
        super(1000L, SingularityExecutorCgroupCfsChecker.getCpuCgroupDirectory(task), (List)ImmutableList.of(StandardWatchEventKinds.ENTRY_MODIFY));
        this.taskId = task.getTaskId();
        this.desiredCfsQuota = (long)cpuHardLimit * desiredCfsPeriod;
        this.desiredCfsPeriod = desiredCfsPeriod;
    }

    private static Path getCpuCgroupDirectory(SingularityExecutorTask task) throws IOException, InterruptedException, ProcessFailedException {
        List<String> cgroups = Files.readAllLines(Paths.get(String.format("/proc/%s/cgroup", task.getTaskDefinition().getExecutorPid()), new String[0]));
        for (String cgroup : cgroups) {
            if (!cgroup.contains(":cpu:")) continue;
            String[] segments = cgroup.split(":");
            String cgroupPath = SingularityExecutorCgroupCfsChecker.getBaseCgroupPath() + segments[segments.length - 1];
            LOG.info("Will start watcher for directory {}", (Object)cgroupPath);
            return Paths.get(cgroupPath, new String[0]);
        }
        throw new RuntimeException(String.format("Found no cpu cgroup from output %s", cgroups));
    }

    private static String getBaseCgroupPath() throws ProcessFailedException, InterruptedException {
        SimpleProcessManager simpleProcessManager = new SimpleProcessManager(LOG);
        return ((String)simpleProcessManager.runCommandWithOutput(FIND_BASE_CGROUP_PATH_COMMAND).get(0)).trim();
    }

    public boolean processEvent(WatchEvent.Kind<?> kind, Path filename) throws IOException {
        block28: {
            try {
                long cfsPeriod;
                Throwable throwable;
                FileOutputStream overwriteFileStream;
                Path fullPath;
                long cfsQuota;
                if (filename.toString().endsWith(CGROUP_CFS_QUOTA_FILE) && (cfsQuota = Long.parseLong(new String(Files.readAllBytes(fullPath = this.getWatchDirectory().resolve(filename)), StandardCharsets.US_ASCII).trim())) != this.desiredCfsQuota) {
                    overwriteFileStream = new FileOutputStream(fullPath.toFile(), false);
                    throwable = null;
                    try {
                        overwriteFileStream.write(Long.toString(this.desiredCfsQuota).getBytes(StandardCharsets.US_ASCII));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (overwriteFileStream != null) {
                            if (throwable != null) {
                                try {
                                    overwriteFileStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                overwriteFileStream.close();
                            }
                        }
                    }
                    LOG.info("Updated cfsQuota from {} to {} for task {}", new Object[]{cfsQuota, this.desiredCfsQuota, this.taskId});
                }
                if (!filename.toString().endsWith(CGROUP_CFS_PERIOD_FILE) || (cfsPeriod = Long.parseLong(new String(Files.readAllBytes(fullPath = this.getWatchDirectory().resolve(filename)), StandardCharsets.US_ASCII).trim())) == this.desiredCfsPeriod) break block28;
                overwriteFileStream = new FileOutputStream(fullPath.toFile(), false);
                throwable = null;
                try {
                    overwriteFileStream.write(Long.toString(this.desiredCfsPeriod).getBytes(StandardCharsets.US_ASCII));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (overwriteFileStream != null) {
                        if (throwable != null) {
                            try {
                                overwriteFileStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            overwriteFileStream.close();
                        }
                    }
                }
                LOG.info("Updated cfsPeriod from {} to {} for task {}", new Object[]{cfsPeriod, this.desiredCfsPeriod, this.taskId});
            }
            catch (Throwable t) {
                LOG.error("Unable to update cfs period/quota values for task {}", (Object)this.taskId, (Object)t);
            }
        }
        return true;
    }
}

