/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.hubspot.deploy.HealthcheckOptions;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.executor.utils.ExecutorUtils;
import com.hubspot.singularity.runner.base.shared.SafeProcessManager;
import java.io.File;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingularityExecutorTaskProcessCallable
extends SafeProcessManager
implements Callable<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(SingularityExecutorTaskProcessCallable.class);
    private final ProcessBuilder processBuilder;
    private final ExecutorUtils executorUtils;
    private final SingularityExecutorConfiguration configuration;
    private final SingularityExecutorTask task;

    public SingularityExecutorTaskProcessCallable(SingularityExecutorConfiguration configuration, SingularityExecutorTask task, ProcessBuilder processBuilder, ExecutorUtils executorUtils) {
        super(task.getLog());
        this.executorUtils = executorUtils;
        this.processBuilder = processBuilder;
        this.configuration = configuration;
        this.task = task;
    }

    @Override
    public Integer call() throws Exception {
        LOG.info("Process being started");
        Process process = this.startProcess(this.processBuilder);
        if (!this.runHealthcheck(process)) {
            this.task.getLog().info("Killing task {} that did not pass health checks", (Object)this.task.getTaskId());
            super.signalKillToProcessIfActive();
        }
        return process.waitFor();
    }

    public SingularityExecutorTask getTask() {
        return this.task;
    }

    public String toString() {
        return "SingularityExecutorTaskProcessCallable [task=" + this.task + "]";
    }

    private boolean runHealthcheck(Process process) {
        Optional<HealthcheckOptions> maybeOptions = this.task.getTaskDefinition().getHealthcheckOptions();
        Optional<String> expectedHealthcheckResultFilePath = this.task.getTaskDefinition().getHealthcheckResultFilePath();
        if (!maybeOptions.isPresent() || !expectedHealthcheckResultFilePath.isPresent()) {
            this.executorUtils.sendStatusUpdate(this.task.getDriver(), this.task.getTaskInfo().getTaskId(), Protos.TaskState.TASK_RUNNING, String.format("Task running process %s", this.getCurrentProcessToString()), this.task.getLog());
            return true;
        }
        LOG.debug("Checking for healthcheck file {}", (Object)expectedHealthcheckResultFilePath.get());
        String taskAppDirectory = this.task.getTaskDefinition().getTaskAppDirectory();
        File fullHealthcheckPath = Paths.get(taskAppDirectory, expectedHealthcheckResultFilePath.get()).toFile();
        Integer healthcheckMaxRetries = maybeOptions.get().getMaxRetries().orElse(this.configuration.getDefaultHealthcheckMaxRetries());
        Integer retryInterval = maybeOptions.get().getIntervalSeconds().orElse(this.configuration.getDefaultHealthcheckInternvalSeconds());
        long maxDelay = this.configuration.getDefaultHealthcheckBaseTimeoutSeconds() + retryInterval * healthcheckMaxRetries;
        try {
            Retryer retryer = RetryerBuilder.newBuilder().retryIfResult(result -> result == HealthCheckResult.WAITING).withWaitStrategy(WaitStrategies.fixedWait((long)retryInterval.intValue(), (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(StopStrategies.stopAfterDelay((long)maxDelay, (TimeUnit)TimeUnit.SECONDS)).build();
            HealthCheckResult result2 = (HealthCheckResult)((Object)retryer.call(() -> {
                if (fullHealthcheckPath.exists()) {
                    return HealthCheckResult.PASSED;
                }
                if (process.isAlive()) {
                    return HealthCheckResult.WAITING;
                }
                return HealthCheckResult.FAILED;
            }));
            if (result2 == HealthCheckResult.PASSED) {
                this.executorUtils.sendStatusUpdate(this.task.getDriver(), this.task.getTaskInfo().getTaskId(), Protos.TaskState.TASK_RUNNING, String.format("Task running process %s (health check file found successfully).", this.getCurrentProcessToString()), this.task.getLog());
                return true;
            }
            this.executorUtils.sendStatusUpdate(this.task.getDriver(), this.task.getTaskInfo().getTaskId(), Protos.TaskState.TASK_FAILED, String.format("Task timed out on health checks after %d seconds (health check file not found).", maxDelay), this.task.getLog());
            return false;
        }
        catch (RetryException | ExecutionException e) {
            this.executorUtils.sendStatusUpdate(this.task.getDriver(), this.task.getTaskInfo().getTaskId(), Protos.TaskState.TASK_FAILED, String.format("Task timed out on health checks after %d seconds (health check file not found).", maxDelay), this.task.getLog());
            return false;
        }
    }

    static enum HealthCheckResult {
        PASSED,
        FAILED,
        WAITING;

    }
}

