/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.shells;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hubspot.singularity.SingularityTaskShellCommandRequest;
import com.hubspot.singularity.SingularityTaskShellCommandUpdate;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import java.util.Optional;

public class SingularityExecutorShellCommandUpdater {
    private final ObjectMapper objectMapper;
    private final SingularityTaskShellCommandRequest shellRequest;
    private final SingularityExecutorTask task;

    public SingularityExecutorShellCommandUpdater(ObjectMapper objectMapper, SingularityTaskShellCommandRequest shellRequest, SingularityExecutorTask task) {
        this.objectMapper = objectMapper;
        this.shellRequest = shellRequest;
        this.task = task;
    }

    public void sendUpdate(SingularityTaskShellCommandUpdate.UpdateType updateType, Optional<String> message, Optional<String> outputFilename) {
        SingularityTaskShellCommandUpdate update = new SingularityTaskShellCommandUpdate(this.shellRequest.getId(), System.currentTimeMillis(), message, outputFilename, updateType);
        try {
            byte[] data = this.objectMapper.writeValueAsBytes((Object)update);
            this.task.getLog().info("Sending update {} ({}) for shell command {}", new Object[]{updateType, message.orElse(""), this.shellRequest.getId()});
            this.task.getDriver().sendFrameworkMessage(data);
        }
        catch (JsonProcessingException e) {
            this.task.getLog().error("Unable to serialize update {}", (Object)update, (Object)e);
        }
    }
}

