/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.shells;

import com.google.common.base.Charsets;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.SingularityTaskShellCommandUpdate;
import com.hubspot.singularity.executor.shells.SingularityExecutorShellCommandUpdater;
import com.hubspot.singularity.runner.base.shared.SafeProcessManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public class SingularityExecutorShellCommandRunnerCallable
extends SafeProcessManager
implements Callable<Integer> {
    private final SingularityExecutorShellCommandUpdater updater;
    private final ProcessBuilder processBuilder;
    private final File outputFile;

    public SingularityExecutorShellCommandRunnerCallable(Logger log, SingularityExecutorShellCommandUpdater updater, ProcessBuilder processBuilder, File outputFile) {
        super(log);
        this.processBuilder = processBuilder;
        this.updater = updater;
        this.outputFile = outputFile;
    }

    @Override
    public Integer call() throws Exception {
        try (PrintWriter outputWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile, true), Charsets.UTF_8));){
            outputWriter.println("#");
            outputWriter.println(String.format("# %s -- Launching %s", new Date(), JavaUtils.SPACE_JOINER.join(this.processBuilder.command())));
            outputWriter.println("#");
        }
        Process process = this.startProcess(this.processBuilder);
        Optional pid = this.getCurrentPid();
        this.updater.sendUpdate(SingularityTaskShellCommandUpdate.UpdateType.STARTED, Optional.of(String.format("pid - %s", pid.orElse(null))), Optional.empty());
        try {
            return process.waitFor();
        }
        catch (InterruptedException ie) {
            this.signalKillToProcessIfActive();
            throw ie;
        }
    }
}

