/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.marshaller.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import net.kencochrane.raven.event.interfaces.StackTraceInterface;
import net.kencochrane.raven.marshaller.json.InterfaceBinding;

public class StackTraceInterfaceBinding
implements InterfaceBinding<StackTraceInterface> {
    private static final String FRAMES_PARAMETER = "frames";
    private static final String FILENAME_PARAMETER = "filename";
    private static final String FUNCTION_PARAMETER = "function";
    private static final String MODULE_PARAMETER = "module";
    private static final String LINE_NO_PARAMETER = "lineno";
    private static final String ABSOLUTE_PATH_PARAMETER = "abs_path";
    private static final String CONTEXT_LINE_PARAMETER = "context_line";
    private static final String PRE_CONTEXT_PARAMETER = "pre_context";
    private static final String POST_CONTEXT_PARAMETER = "post_context";
    private static final String IN_APP_PARAMETER = "in_app";
    private static final String VARIABLES_PARAMETER = "vars";
    private Collection<String> notInAppFrames = Collections.emptyList();
    private boolean removeCommonFramesWithEnclosing = true;

    private void writeFrame(JsonGenerator generator, StackTraceElement stackTraceElement, boolean commonWithEnclosing) throws IOException {
        generator.writeStartObject();
        generator.writeStringField(MODULE_PARAMETER, stackTraceElement.getClassName());
        generator.writeBooleanField(IN_APP_PARAMETER, (!this.removeCommonFramesWithEnclosing || !commonWithEnclosing) && this.isFrameInApp(stackTraceElement));
        generator.writeStringField(FUNCTION_PARAMETER, stackTraceElement.getMethodName());
        generator.writeNumberField(LINE_NO_PARAMETER, stackTraceElement.getLineNumber());
        generator.writeEndObject();
    }

    private boolean isFrameInApp(StackTraceElement stackTraceElement) {
        for (String notInAppFrame : this.notInAppFrames) {
            if (!stackTraceElement.getClassName().startsWith(notInAppFrame)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeInterface(JsonGenerator generator, StackTraceInterface stackTraceInterface) throws IOException {
        StackTraceElement[] stackTrace = stackTraceInterface.getStackTrace();
        generator.writeStartObject();
        generator.writeArrayFieldStart(FRAMES_PARAMETER);
        int commonWithEnclosing = stackTraceInterface.getFramesCommonWithEnclosing();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            this.writeFrame(generator, stackTrace[i], commonWithEnclosing-- > 0);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    public void setRemoveCommonFramesWithEnclosing(boolean removeCommonFramesWithEnclosing) {
        this.removeCommonFramesWithEnclosing = removeCommonFramesWithEnclosing;
    }

    public void setNotInAppFrames(Collection<String> notInAppFrames) {
        this.notInAppFrames = notInAppFrames;
    }
}

