/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.jul;

import com.google.common.base.Splitter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import net.kencochrane.raven.Raven;
import net.kencochrane.raven.RavenFactory;
import net.kencochrane.raven.dsn.Dsn;
import net.kencochrane.raven.dsn.InvalidDsnException;
import net.kencochrane.raven.environment.RavenEnvironment;
import net.kencochrane.raven.event.Event;
import net.kencochrane.raven.event.EventBuilder;
import net.kencochrane.raven.event.interfaces.ExceptionInterface;
import net.kencochrane.raven.event.interfaces.MessageInterface;
import org.slf4j.MDC;

public class SentryHandler
extends Handler {
    public static final String THREAD_ID = "Raven-ThreadId";
    protected Raven raven;
    protected String dsn;
    protected String ravenFactory;
    protected Map<String, String> tags = Collections.emptyMap();
    private Set<String> extraTags = Collections.emptySet();

    public SentryHandler() {
        this.retrieveProperties();
    }

    public SentryHandler(Raven raven) {
        this.raven = raven;
    }

    protected static Event.Level getLevel(Level level) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return Event.Level.ERROR;
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return Event.Level.WARNING;
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return Event.Level.INFO;
        }
        if (level.intValue() >= Level.ALL.intValue()) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    protected static List<String> formatMessageParameters(Object[] parameters) {
        ArrayList<String> formattedParameters = new ArrayList<String>(parameters.length);
        for (Object parameter : parameters) {
            formattedParameters.add(parameter != null ? parameter.toString() : null);
        }
        return formattedParameters;
    }

    protected void retrieveProperties() {
        String extraTagsProperty;
        LogManager manager = LogManager.getLogManager();
        String className = SentryHandler.class.getName();
        this.dsn = manager.getProperty(className + ".dsn");
        this.ravenFactory = manager.getProperty(className + ".ravenFactory");
        String tagsProperty = manager.getProperty(className + ".tags");
        if (tagsProperty != null) {
            this.tags = Splitter.on(",").withKeyValueSeparator(":").split(tagsProperty);
        }
        if ((extraTagsProperty = manager.getProperty(className + ".extraTags")) != null) {
            this.extraTags = new HashSet<String>(Arrays.asList(extraTagsProperty.split(",")));
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record) || RavenEnvironment.isManagingThread()) {
            return;
        }
        RavenEnvironment.startManagingThread();
        try {
            if (this.raven == null) {
                this.initRaven();
            }
            Event event = this.buildEvent(record);
            this.raven.sendEvent(event);
        }
        catch (Exception e) {
            this.reportError("An exception occurred while creating a new event in Raven", e, 1);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }

    protected void initRaven() {
        try {
            if (this.dsn == null) {
                this.dsn = Dsn.dsnLookup();
            }
            this.raven = RavenFactory.ravenInstance(new Dsn(this.dsn), this.ravenFactory);
        }
        catch (InvalidDsnException e) {
            this.reportError("An exception occurred during the retrieval of the DSN for Raven", e, 4);
        }
        catch (Exception e) {
            this.reportError("An exception occurred during the creation of a Raven instance", e, 4);
        }
    }

    protected Event buildEvent(LogRecord record) {
        EventBuilder eventBuilder = new EventBuilder().withLevel(SentryHandler.getLevel(record.getLevel())).withTimestamp(new Date(record.getMillis())).withLogger(record.getLoggerName());
        String message = record.getMessage();
        if (record.getResourceBundle() != null && record.getResourceBundle().containsKey(record.getMessage())) {
            message = record.getResourceBundle().getString(record.getMessage());
        }
        if (record.getParameters() != null) {
            List<String> parameters = SentryHandler.formatMessageParameters(record.getParameters());
            eventBuilder.withSentryInterface(new MessageInterface(message, parameters));
            message = MessageFormat.format(message, record.getParameters());
        }
        eventBuilder.withMessage(message);
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            eventBuilder.withSentryInterface(new ExceptionInterface(throwable));
        }
        if (record.getSourceClassName() != null && record.getSourceMethodName() != null) {
            StackTraceElement fakeFrame = new StackTraceElement(record.getSourceClassName(), record.getSourceMethodName(), null, -1);
            eventBuilder.withCulprit(fakeFrame);
        } else {
            eventBuilder.withCulprit(record.getLoggerName());
        }
        Map<String, String> mdc = MDC.getMDCAdapter().getCopyOfContextMap();
        if (mdc != null) {
            for (Map.Entry<String, String> mdcEntry : mdc.entrySet()) {
                if (this.extraTags.contains(mdcEntry.getKey())) {
                    eventBuilder.withTag(mdcEntry.getKey(), mdcEntry.getValue());
                    continue;
                }
                eventBuilder.withExtra(mdcEntry.getKey(), mdcEntry.getValue());
            }
        }
        for (Map.Entry<String, String> tagEntry : this.tags.entrySet()) {
            eventBuilder.withTag(tagEntry.getKey(), tagEntry.getValue());
        }
        eventBuilder.withExtra(THREAD_ID, record.getThreadID());
        this.raven.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        RavenEnvironment.startManagingThread();
        try {
            if (this.raven != null) {
                this.raven.closeConnection();
            }
        }
        catch (Exception e) {
            this.reportError("An exception occurred while closing the Raven connection", e, 3);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }
}

