/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.kencochrane.raven.connection.Connection;
import net.kencochrane.raven.environment.RavenEnvironment;
import net.kencochrane.raven.event.Event;
import net.kencochrane.raven.event.EventBuilder;
import net.kencochrane.raven.event.helper.EventBuilderHelper;
import net.kencochrane.raven.event.interfaces.ExceptionInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Raven {
    private static final Logger logger = LoggerFactory.getLogger(Raven.class);
    private final Set<EventBuilderHelper> builderHelpers = new HashSet<EventBuilderHelper>();
    private Connection connection;

    public void runBuilderHelpers(EventBuilder eventBuilder) {
        for (EventBuilderHelper builderHelper : this.builderHelpers) {
            builderHelper.helpBuildingEvent(eventBuilder);
        }
    }

    public void sendEvent(Event event) {
        try {
            this.connection.send(event);
        }
        catch (Exception e) {
            logger.error("An exception occurred while sending the event to Sentry.", e);
        }
    }

    public void sendMessage(String message) {
        EventBuilder eventBuilder = new EventBuilder().withMessage(message).withLevel(Event.Level.INFO);
        this.runBuilderHelpers(eventBuilder);
        this.sendEvent(eventBuilder.build());
    }

    public void sendException(Exception exception) {
        EventBuilder eventBuilder = new EventBuilder().withMessage(exception.getMessage()).withLevel(Event.Level.ERROR).withSentryInterface(new ExceptionInterface(exception));
        this.runBuilderHelpers(eventBuilder);
        this.sendEvent(eventBuilder.build());
    }

    public void removeBuilderHelper(EventBuilderHelper builderHelper) {
        logger.info("Removing '{}' from the list of builder helpers.", (Object)builderHelper);
        this.builderHelpers.remove(builderHelper);
    }

    public void addBuilderHelper(EventBuilderHelper builderHelper) {
        logger.info("Adding '{}' to the list of builder helpers.", (Object)builderHelper);
        this.builderHelpers.add(builderHelper);
    }

    public Set<EventBuilderHelper> getBuilderHelpers() {
        return Collections.unmodifiableSet(this.builderHelpers);
    }

    public void closeConnection() {
        try {
            this.connection.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't close the Raven connection", e);
        }
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String toString() {
        return "Raven{name=" + RavenEnvironment.NAME + ", connection=" + this.connection + '}';
    }
}

