/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import io.dropwizard.validation.ValidationMethod;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;

public class ConstraintViolations {
    private ConstraintViolations() {
    }

    public static <T> String format(ConstraintViolation<T> v) {
        if (v.getConstraintDescriptor().getAnnotation() instanceof ValidationMethod) {
            ImmutableList<Path.Node> nodes = ImmutableList.copyOf(v.getPropertyPath());
            List usefulNodes = nodes.subList(0, nodes.size() - 1);
            String msg = v.getMessage().startsWith(".") ? "%s%s" : "%s %s";
            return String.format(msg, Joiner.on('.').join(usefulNodes), v.getMessage()).trim();
        }
        return String.format("%s %s (was %s)", v.getPropertyPath(), v.getMessage(), v.getInvalidValue());
    }

    public static <T> ImmutableList<String> format(Set<ConstraintViolation<T>> violations) {
        HashSet<String> errors = Sets.newHashSet();
        for (ConstraintViolation<T> v : violations) {
            errors.add(ConstraintViolations.format(v));
        }
        return ImmutableList.copyOf(Ordering.natural().sortedCopy(errors));
    }

    public static ImmutableList<String> formatUntyped(Set<ConstraintViolation<?>> violations) {
        HashSet<String> errors = Sets.newHashSet();
        for (ConstraintViolation<?> v : violations) {
            errors.add(ConstraintViolations.format(v));
        }
        return ImmutableList.copyOf(Ordering.natural().sortedCopy(errors));
    }

    public static <T> ImmutableSet<ConstraintViolation<?>> copyOf(Set<ConstraintViolation<T>> violations) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ConstraintViolation<T> violation : violations) {
            builder.add(violation);
        }
        return builder.build();
    }
}

