/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class AuthRegistryConfig {
    @JsonIgnore
    private final Map<String, String> properties = new HashMap<String, String>();
    @JsonProperty(value="configs")
    private final Map<String, Map<String, String>> configs = new HashMap<String, Map<String, String>>();
    @JsonIgnore
    private final String repository;
    @JsonIgnore
    private final String username;
    @JsonIgnore
    private final String password;
    @JsonIgnore
    private final String auth;
    @JsonIgnore
    private final String email;
    @JsonIgnore
    private final String serverAddress;
    public static final AuthRegistryConfig EMPTY = new AuthRegistryConfig("", "", "", "", "", "");

    public AuthRegistryConfig(String repository, String username, String password, String auth, String email, String serverAddress) {
        this.repository = repository;
        this.username = username;
        this.password = password;
        this.auth = auth;
        this.email = email;
        this.serverAddress = serverAddress;
        this.properties.put("username", username);
        this.properties.put("password", password);
        this.properties.put("auth", auth);
        this.properties.put("email", email);
        this.properties.put("serveraddress", serverAddress);
        this.configs.put(repository, this.properties);
    }

    public AuthRegistryConfig(String repository, String username, String password, String email, String serverAddress) {
        this(repository, username, password, "", email, serverAddress);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthRegistryConfig config = (AuthRegistryConfig)o;
        if (this.repository != null ? !this.repository.equals(config.repository) : config.repository != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(config.username) : config.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(config.password) : config.password != null) {
            return false;
        }
        if (this.auth != null ? !this.auth.equals(config.auth) : config.auth != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(config.email) : config.email != null) {
            return false;
        }
        return !(this.serverAddress != null ? !this.serverAddress.equals(config.serverAddress) : config.serverAddress != null);
    }

    public int hashCode() {
        int result = this.repository != null ? this.repository.hashCode() : 0;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.serverAddress != null ? this.serverAddress.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("repository", this.repository).add("username", this.username).add("password", this.password).add("auth", this.auth).add("email", this.email).add("serverAddress", this.serverAddress).toString();
    }
}

