/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.api.SingularityExpiringRequestParent;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.UUID;

public class SingularityBounceRequest
extends SingularityExpiringRequestParent {
    private final Optional<Boolean> incremental;
    private final Optional<Boolean> skipHealthchecks;

    @JsonCreator
    public SingularityBounceRequest(@JsonProperty(value="incremental") Optional<Boolean> incremental, @JsonProperty(value="skipHealthchecks") Optional<Boolean> skipHealthchecks, @JsonProperty(value="durationMillis") Optional<Long> durationMillis, @JsonProperty(value="actionId") Optional<String> actionId, @JsonProperty(value="message") Optional<String> message) {
        super(durationMillis, actionId, message);
        this.incremental = incremental;
        this.skipHealthchecks = skipHealthchecks;
    }

    public static SingularityBounceRequest defaultRequest() {
        return new SingularityBounceRequest(Optional.absent(), Optional.absent(), Optional.absent(), Optional.of(UUID.randomUUID().toString()), Optional.absent());
    }

    @ApiModelProperty(required=false, value="If present and set to true, old tasks will be killed as soon as replacement tasks are available, instead of waiting for all replacement tasks to be healthy")
    public Optional<Boolean> getIncremental() {
        return this.incremental;
    }

    @ApiModelProperty(required=false, value="Instruct replacement tasks for this bounce only to skip healthchecks")
    public Optional<Boolean> getSkipHealthchecks() {
        return this.skipHealthchecks;
    }

    @Override
    public String toString() {
        return "SingularityBounceRequest [incremental=" + this.incremental + ", skipHealthchecks=" + this.skipHealthchecks + ", toString()=" + super.toString() + "]";
    }
}

