/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.singularity.SingularityDeploy;
import com.hubspot.singularity.SingularityPendingTask;
import com.hubspot.singularity.SingularityRequest;
import java.util.Objects;

public class SingularityTaskRequest
implements Comparable<SingularityTaskRequest> {
    private final SingularityRequest request;
    private final SingularityDeploy deploy;
    private final SingularityPendingTask pendingTask;

    @JsonCreator
    public SingularityTaskRequest(@JsonProperty(value="request") SingularityRequest request, @JsonProperty(value="deploy") SingularityDeploy deploy, @JsonProperty(value="pendingTask") SingularityPendingTask pendingTask) {
        this.request = request;
        this.deploy = deploy;
        this.pendingTask = pendingTask;
    }

    public SingularityRequest getRequest() {
        return this.request;
    }

    public SingularityDeploy getDeploy() {
        return this.deploy;
    }

    public SingularityPendingTask getPendingTask() {
        return this.pendingTask;
    }

    public int hashCode() {
        return Objects.hash(this.pendingTask.getPendingTaskId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingularityTaskRequest other = (SingularityTaskRequest)obj;
        return !(this.pendingTask == null ? other.pendingTask != null : !this.pendingTask.getPendingTaskId().equals(other.pendingTask.getPendingTaskId()));
    }

    @Override
    public int compareTo(SingularityTaskRequest o) {
        return this.getPendingTask().getPendingTaskId().compareTo(o.getPendingTask().getPendingTaskId());
    }

    public String toString() {
        return "SingularityTaskRequest [request=" + this.request + ", deploy=" + this.deploy + ", pendingTask=" + this.pendingTask + "]";
    }
}

