/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.hubspot.singularity.ExtendedTaskState;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.SingularityTaskIdHolder;
import javax.annotation.Nonnull;

public class SingularityTaskHistoryUpdate
extends SingularityTaskIdHolder
implements Comparable<SingularityTaskHistoryUpdate> {
    private final long timestamp;
    private final ExtendedTaskState taskState;
    private final Optional<String> statusMessage;
    private final Optional<String> statusReason;

    public static Optional<SingularityTaskHistoryUpdate> getUpdate(Iterable<SingularityTaskHistoryUpdate> updates, final ExtendedTaskState taskState) {
        return Iterables.tryFind(updates, new Predicate<SingularityTaskHistoryUpdate>(){

            @Override
            public boolean apply(@Nonnull SingularityTaskHistoryUpdate input) {
                return input.getTaskState() == taskState;
            }
        });
    }

    public static SimplifiedTaskState getCurrentState(Iterable<SingularityTaskHistoryUpdate> updates) {
        SimplifiedTaskState state = SimplifiedTaskState.UNKNOWN;
        if (updates == null) {
            return state;
        }
        for (SingularityTaskHistoryUpdate update : updates) {
            if (update.getTaskState().isDone()) {
                return SimplifiedTaskState.DONE;
            }
            if (update.getTaskState() == ExtendedTaskState.TASK_RUNNING) {
                state = SimplifiedTaskState.RUNNING;
                continue;
            }
            if (state != SimplifiedTaskState.UNKNOWN) continue;
            state = SimplifiedTaskState.WAITING;
        }
        return state;
    }

    @JsonCreator
    public SingularityTaskHistoryUpdate(@JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="taskState") ExtendedTaskState taskState, @JsonProperty(value="statusMessage") Optional<String> statusMessage, @JsonProperty(value="statusReason") Optional<String> statusReason) {
        super(taskId);
        this.timestamp = timestamp;
        this.taskState = taskState;
        this.statusMessage = statusMessage;
        this.statusReason = statusReason;
    }

    @Override
    public int compareTo(SingularityTaskHistoryUpdate o) {
        return ComparisonChain.start().compare(this.taskState.ordinal(), o.getTaskState().ordinal()).compare(this.timestamp, o.getTimestamp()).compare((Comparable<?>)((Object)o.getTaskId().getId()), (Comparable<?>)((Object)this.getTaskId().getId())).result();
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.getTaskId(), this.timestamp, this.taskState, this.statusMessage, this.statusReason});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SingularityTaskHistoryUpdate that = (SingularityTaskHistoryUpdate)other;
        return Objects.equal(this.getTaskId(), that.getTaskId()) && Objects.equal(this.timestamp, that.timestamp) && Objects.equal((Object)this.taskState, (Object)that.taskState) && Objects.equal(this.statusMessage, that.statusMessage) && Objects.equal(this.statusReason, that.statusReason);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ExtendedTaskState getTaskState() {
        return this.taskState;
    }

    public Optional<String> getStatusMessage() {
        return this.statusMessage;
    }

    public Optional<String> getStatusReason() {
        return this.statusReason;
    }

    public String toString() {
        return "SingularityTaskHistoryUpdate[timestamp=" + this.timestamp + ", taskState=" + (Object)((Object)this.taskState) + ", statusMessage=" + this.statusMessage + ", statusReason=" + this.statusReason + ']';
    }

    public static enum SimplifiedTaskState {
        UNKNOWN,
        WAITING,
        RUNNING,
        DONE;

    }
}

