/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityHostState;
import java.util.List;

public class SingularityState {
    private final int activeTasks;
    private final int pausedRequests;
    private final int activeRequests;
    private final int cooldownRequests;
    private final int scheduledTasks;
    private final int lateTasks;
    private final int futureTasks;
    private final int cleaningTasks;
    private final int lbCleanupTasks;
    private final int lbCleanupRequests;
    private final long maxTaskLag;
    private final int pendingRequests;
    private final int cleaningRequests;
    private final int finishedRequests;
    private final int activeSlaves;
    private final int deadSlaves;
    private final int decommissioningSlaves;
    private final int unknownSlaves;
    private final int activeRacks;
    private final int deadRacks;
    private final int decommissioningRacks;
    private final int unknownRacks;
    private final long oldestDeploy;
    private final int numDeploys;
    private final long generatedAt;
    private final List<SingularityHostState> hostStates;
    private final List<String> overProvisionedRequestIds;
    private final List<String> underProvisionedRequestIds;
    private final int overProvisionedRequests;
    private final int underProvisionedRequests;
    private final Optional<Boolean> authDatastoreHealthy;

    @JsonCreator
    public SingularityState(@JsonProperty(value="activeTasks") int activeTasks, @JsonProperty(value="activeRequests") int activeRequests, @JsonProperty(value="cooldownRequests") int cooldownRequests, @JsonProperty(value="pausedRequests") int pausedRequests, @JsonProperty(value="scheduledTasks") int scheduledTasks, @JsonProperty(value="pendingRequests") int pendingRequests, @JsonProperty(value="lbCleanupTasks") int lbCleanupTasks, @JsonProperty(value="lbCleanupRequests") int lbCleanupRequests, @JsonProperty(value="cleaningRequests") int cleaningRequests, @JsonProperty(value="activeSlaves") int activeSlaves, @JsonProperty(value="deadSlaves") int deadSlaves, @JsonProperty(value="decommissioningSlaves") int decommissioningSlaves, @JsonProperty(value="activeRacks") int activeRacks, @JsonProperty(value="deadRacks") int deadRacks, @JsonProperty(value="decommissioningRacks") int decommissioningRacks, @JsonProperty(value="cleaningTasks") int cleaningTasks, @JsonProperty(value="hostStates") List<SingularityHostState> hostStates, @JsonProperty(value="oldestDeploy") long oldestDeploy, @JsonProperty(value="numDeploys") int numDeploys, @JsonProperty(value="lateTasks") int lateTasks, @JsonProperty(value="futureTasks") int futureTasks, @JsonProperty(value="maxTaskLag") long maxTaskLag, @JsonProperty(value="generatedAt") long generatedAt, @JsonProperty(value="overProvisionedRequestIds") List<String> overProvisionedRequestIds, @JsonProperty(value="underProvisionedRequestIds") List<String> underProvisionedRequestIds, @JsonProperty(value="overProvisionedRequests") int overProvisionedRequests, @JsonProperty(value="underProvisionedRequests") int underProvisionedRequests, @JsonProperty(value="finishedRequests") int finishedRequests, @JsonProperty(value="unknownRacks") int unknownRacks, @JsonProperty(value="unknownSlaves") int unknownSlaves, @JsonProperty(value="authDatastoreHealthy") Optional<Boolean> authDatastoreHealthy) {
        this.activeTasks = activeTasks;
        this.activeRequests = activeRequests;
        this.pausedRequests = pausedRequests;
        this.cooldownRequests = cooldownRequests;
        this.scheduledTasks = scheduledTasks;
        this.pendingRequests = pendingRequests;
        this.cleaningRequests = cleaningRequests;
        this.activeRacks = activeRacks;
        this.generatedAt = generatedAt;
        this.activeSlaves = activeSlaves;
        this.deadRacks = deadRacks;
        this.deadSlaves = deadSlaves;
        this.unknownSlaves = unknownSlaves;
        this.unknownRacks = unknownRacks;
        this.decommissioningRacks = decommissioningRacks;
        this.decommissioningSlaves = decommissioningSlaves;
        this.cleaningTasks = cleaningTasks;
        this.hostStates = hostStates;
        this.lateTasks = lateTasks;
        this.finishedRequests = finishedRequests;
        this.futureTasks = futureTasks;
        this.maxTaskLag = maxTaskLag;
        this.oldestDeploy = oldestDeploy;
        this.numDeploys = numDeploys;
        this.lbCleanupTasks = lbCleanupTasks;
        this.lbCleanupRequests = lbCleanupRequests;
        this.underProvisionedRequests = underProvisionedRequests;
        this.overProvisionedRequests = overProvisionedRequests;
        this.overProvisionedRequestIds = overProvisionedRequestIds;
        this.underProvisionedRequestIds = underProvisionedRequestIds;
        this.authDatastoreHealthy = authDatastoreHealthy;
    }

    public int getFinishedRequests() {
        return this.finishedRequests;
    }

    public long getGeneratedAt() {
        return this.generatedAt;
    }

    public long getOldestDeploy() {
        return this.oldestDeploy;
    }

    public int getNumDeploys() {
        return this.numDeploys;
    }

    public int getPausedRequests() {
        return this.pausedRequests;
    }

    public List<SingularityHostState> getHostStates() {
        return this.hostStates;
    }

    public int getCleaningTasks() {
        return this.cleaningTasks;
    }

    public int getActiveSlaves() {
        return this.activeSlaves;
    }

    public int getDeadSlaves() {
        return this.deadSlaves;
    }

    public int getDecommissioningSlaves() {
        return this.decommissioningSlaves;
    }

    @Deprecated
    public int getDecomissioningSlaves() {
        return this.decommissioningSlaves;
    }

    public int getActiveRacks() {
        return this.activeRacks;
    }

    public int getDeadRacks() {
        return this.deadRacks;
    }

    @Deprecated
    public int getDecomissioningRacks() {
        return this.decommissioningRacks;
    }

    public int getDecommissioningRacks() {
        return this.decommissioningRacks;
    }

    public int getActiveTasks() {
        return this.activeTasks;
    }

    public int getAllRequests() {
        return this.getActiveRequests() + this.getCooldownRequests() + this.getPausedRequests();
    }

    public int getActiveRequests() {
        return this.activeRequests;
    }

    public int getCooldownRequests() {
        return this.cooldownRequests;
    }

    public int getScheduledTasks() {
        return this.scheduledTasks;
    }

    public int getPendingRequests() {
        return this.pendingRequests;
    }

    public int getCleaningRequests() {
        return this.cleaningRequests;
    }

    public int getLateTasks() {
        return this.lateTasks;
    }

    public int getFutureTasks() {
        return this.futureTasks;
    }

    public long getMaxTaskLag() {
        return this.maxTaskLag;
    }

    public int getLbCleanupTasks() {
        return this.lbCleanupTasks;
    }

    public int getLbCleanupRequests() {
        return this.lbCleanupRequests;
    }

    public List<String> getOverProvisionedRequestIds() {
        return this.overProvisionedRequestIds;
    }

    public List<String> getUnderProvisionedRequestIds() {
        return this.underProvisionedRequestIds;
    }

    public int getOverProvisionedRequests() {
        return this.overProvisionedRequests;
    }

    public int getUnderProvisionedRequests() {
        return this.underProvisionedRequests;
    }

    public int getUnknownSlaves() {
        return this.unknownSlaves;
    }

    public int getUnknownRacks() {
        return this.unknownRacks;
    }

    public Optional<Boolean> getAuthDatastoreHealthy() {
        return this.authDatastoreHealthy;
    }

    public String toString() {
        return "SingularityState [activeTasks=" + this.activeTasks + ", pausedRequests=" + this.pausedRequests + ", activeRequests=" + this.activeRequests + ", cooldownRequests=" + this.cooldownRequests + ", scheduledTasks=" + this.scheduledTasks + ", lateTasks=" + this.lateTasks + ", futureTasks=" + this.futureTasks + ", cleaningTasks=" + this.cleaningTasks + ", lbCleanupTasks=" + this.lbCleanupTasks + ", lbCleanupRequests=" + this.lbCleanupRequests + ", maxTaskLag=" + this.maxTaskLag + ", pendingRequests=" + this.pendingRequests + ", cleaningRequests=" + this.cleaningRequests + ", finishedRequests=" + this.finishedRequests + ", activeSlaves=" + this.activeSlaves + ", deadSlaves=" + this.deadSlaves + ", decommissioningSlaves=" + this.decommissioningSlaves + ", unknownSlaves=" + this.unknownSlaves + ", activeRacks=" + this.activeRacks + ", deadRacks=" + this.deadRacks + ", decommissioningRacks=" + this.decommissioningRacks + ", unknownRacks=" + this.unknownRacks + ", oldestDeploy=" + this.oldestDeploy + ", numDeploys=" + this.numDeploys + ", generatedAt=" + this.generatedAt + ", hostStates=" + this.hostStates + ", overProvisionedRequestIds=" + this.overProvisionedRequestIds + ", underProvisionedRequestIds=" + this.underProvisionedRequestIds + ", overProvisionedRequests=" + this.overProvisionedRequests + ", underProvisionedRequests=" + this.underProvisionedRequests + ", authDatastoreHealthy=" + this.authDatastoreHealthy + "]";
    }
}

