/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.singularity.SingularityMachineAbstraction;
import com.hubspot.singularity.SingularityMachineStateHistoryUpdate;
import com.wordnik.swagger.annotations.ApiModel;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.Map;

@ApiModel(description="Singularity's view of a Mesos slave")
public class SingularitySlave
extends SingularityMachineAbstraction<SingularitySlave> {
    private final String host;
    private final String rackId;
    private final Map<String, String> attributes;

    public SingularitySlave(String slaveId, String host, String rackId, Map<String, String> attributes) {
        super(slaveId);
        this.host = host;
        this.rackId = rackId;
        this.attributes = attributes;
    }

    @JsonCreator
    public SingularitySlave(@JsonProperty(value="slaveId") String slaveId, @JsonProperty(value="firstSeenAt") long firstSeenAt, @JsonProperty(value="currentState") SingularityMachineStateHistoryUpdate currentState, @JsonProperty(value="host") String host, @JsonProperty(value="rackId") String rackId, @JsonProperty(value="attributes") Map<String, String> attributes) {
        super(slaveId, firstSeenAt, currentState);
        this.host = host;
        this.rackId = rackId;
        this.attributes = attributes;
    }

    @Override
    public SingularitySlave changeState(SingularityMachineStateHistoryUpdate newState) {
        return new SingularitySlave(this.getId(), this.getFirstSeenAt(), newState, this.host, this.rackId, this.attributes);
    }

    @ApiModelProperty(value="Slave hostname")
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonIgnore
    public String getName() {
        return String.format("%s (%s)", this.getHost(), this.getId());
    }

    @Override
    @JsonIgnore
    public String getTypeName() {
        return "Slave";
    }

    @ApiModelProperty(value="Slave rack ID")
    public String getRackId() {
        return this.rackId;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "SingularitySlave [host=" + this.host + ", rackId=" + this.rackId + ", getId()=" + this.getId() + ", getFirstSeenAt()=" + this.getFirstSeenAt() + ", getCurrentState()=" + this.getCurrentState() + "]";
    }
}

