/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Optional;
import com.hubspot.singularity.MachineState;
import com.hubspot.singularity.SingularityMachineStateHistoryUpdate;
import java.util.Objects;

public abstract class SingularityMachineAbstraction<T extends SingularityMachineAbstraction<T>> {
    private final String id;
    private final long firstSeenAt;
    private final SingularityMachineStateHistoryUpdate currentState;

    public SingularityMachineAbstraction(String id) {
        this(id, System.currentTimeMillis(), new SingularityMachineStateHistoryUpdate(id, MachineState.ACTIVE, System.currentTimeMillis(), Optional.absent(), Optional.absent()));
    }

    public SingularityMachineAbstraction(String id, long firstSeenAt, SingularityMachineStateHistoryUpdate currentState) {
        this.id = id;
        this.currentState = currentState;
        this.firstSeenAt = firstSeenAt;
    }

    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public abstract String getName();

    @JsonIgnore
    public abstract String getTypeName();

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingularityMachineAbstraction other = (SingularityMachineAbstraction)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public long getFirstSeenAt() {
        return this.firstSeenAt;
    }

    public SingularityMachineStateHistoryUpdate getCurrentState() {
        return this.currentState;
    }

    public abstract T changeState(SingularityMachineStateHistoryUpdate var1);
}

