/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.hubspot.singularity.DeployState;
import com.hubspot.singularity.SingularityDeployFailure;
import com.hubspot.singularity.SingularityLoadBalancerUpdate;
import java.util.Collections;
import java.util.List;

public class SingularityDeployResult {
    private final DeployState deployState;
    private final Optional<SingularityLoadBalancerUpdate> lbUpdate;
    private final Optional<String> message;
    private final List<SingularityDeployFailure> deployFailures;
    private final long timestamp;

    public SingularityDeployResult(DeployState deployState) {
        this(deployState, Optional.absent(), Optional.absent(), Collections.emptyList(), System.currentTimeMillis());
    }

    public SingularityDeployResult(DeployState deployState, String message) {
        this(deployState, Optional.of(message), Optional.absent(), Collections.emptyList(), System.currentTimeMillis());
    }

    public SingularityDeployResult(DeployState deployState, Optional<String> message, Optional<SingularityLoadBalancerUpdate> lbUpdate) {
        this(deployState, message, lbUpdate, Collections.emptyList(), System.currentTimeMillis());
    }

    public SingularityDeployResult(DeployState deployState, SingularityLoadBalancerUpdate lbUpdate, List<SingularityDeployFailure> deployFailures) {
        this(deployState, Optional.of(String.format("Load balancer had state %s%s", new Object[]{lbUpdate.getLoadBalancerState(), lbUpdate.getMessage().isPresent() && lbUpdate.getMessage().get().length() > 0 ? String.format(" (%s)", lbUpdate.getMessage().get()) : ""})), Optional.of(lbUpdate), deployFailures, System.currentTimeMillis());
    }

    @JsonCreator
    public SingularityDeployResult(@JsonProperty(value="deployState") DeployState deployState, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="lbUpdate") Optional<SingularityLoadBalancerUpdate> lbUpdate, @JsonProperty(value="deployFailures") List<SingularityDeployFailure> deployFailures, @JsonProperty(value="timestamp") long timestamp) {
        this.deployState = deployState;
        this.lbUpdate = lbUpdate;
        this.message = message;
        this.deployFailures = Objects.firstNonNull(deployFailures, Collections.emptyList());
        this.timestamp = timestamp;
    }

    public Optional<SingularityLoadBalancerUpdate> getLbUpdate() {
        return this.lbUpdate;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public DeployState getDeployState() {
        return this.deployState;
    }

    public List<SingularityDeployFailure> getDeployFailures() {
        return this.deployFailures;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "SingularityDeployResult [deployState=" + (Object)((Object)this.deployState) + ", lbUpdate=" + this.lbUpdate + ", message=" + this.message + ", deployFailures=" + this.deployFailures + ", timestamp=" + this.timestamp + "]";
    }
}

