/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityDeploy;
import com.hubspot.singularity.SingularityDeployMarker;
import com.hubspot.singularity.SingularityDeployResult;
import com.hubspot.singularity.SingularityDeployStatistics;
import com.hubspot.singularity.SingularityHistoryItem;

public class SingularityDeployHistory
implements Comparable<SingularityDeployHistory>,
SingularityHistoryItem {
    private final Optional<SingularityDeployResult> deployResult;
    private final SingularityDeployMarker deployMarker;
    private final Optional<SingularityDeploy> deploy;
    private final Optional<SingularityDeployStatistics> deployStatistics;

    @JsonCreator
    public SingularityDeployHistory(@JsonProperty(value="deployResult") Optional<SingularityDeployResult> deployResult, @JsonProperty(value="deployMarker") SingularityDeployMarker deployMarker, @JsonProperty(value="deploy") Optional<SingularityDeploy> deploy, @JsonProperty(value="deployStatistics") Optional<SingularityDeployStatistics> deployStatistics) {
        this.deployResult = deployResult;
        this.deployMarker = deployMarker;
        this.deploy = deploy;
        this.deployStatistics = deployStatistics;
    }

    @Override
    public int compareTo(SingularityDeployHistory o) {
        return o.getDeployMarker().compareTo(this.getDeployMarker());
    }

    public int hashCode() {
        return Objects.hashCode(this.deployResult, this.deployMarker, this.deploy, this.deployStatistics);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SingularityDeployHistory that = (SingularityDeployHistory)other;
        return Objects.equal(this.deployResult, that.deployResult) && Objects.equal(this.deployMarker, that.deployMarker) && Objects.equal(this.deploy, that.deploy) && Objects.equal(this.deployStatistics, that.deployStatistics);
    }

    public Optional<SingularityDeployResult> getDeployResult() {
        return this.deployResult;
    }

    public SingularityDeployMarker getDeployMarker() {
        return this.deployMarker;
    }

    public Optional<SingularityDeploy> getDeploy() {
        return this.deploy;
    }

    @Override
    @JsonIgnore
    public long getCreateTimestampForCalculatingHistoryAge() {
        return this.deployMarker.getTimestamp();
    }

    public Optional<SingularityDeployStatistics> getDeployStatistics() {
        return this.deployStatistics;
    }

    public String toString() {
        return "SingularityDeployHistory [deployResult=" + this.deployResult + ", deployMarker=" + this.deployMarker + ", deploy=" + this.deploy + ", deployStatistics=" + this.deployStatistics + "]";
    }
}

