/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JsonHelpers {
    private JsonHelpers() {
        throw new AssertionError((Object)"do not instantiate");
    }

    public static <T> Optional<List<T>> copyOfList(Optional<List<T>> list) {
        return list.isPresent() ? Optional.of(Lists.newArrayList((Iterable)list.get())) : list;
    }

    public static <T> Optional<Set<T>> copyOfSet(Optional<Set<T>> set) {
        return set.isPresent() ? Optional.of(Sets.newHashSet((Iterable)set.get())) : set;
    }

    public static <K, V> Optional<Map<K, V>> copyOfMap(Optional<Map<K, V>> map) {
        return map.isPresent() ? Optional.of(Maps.newHashMap(map.get())) : map;
    }
}

