/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.mesos.Protos;

public enum ExtendedTaskState {
    TASK_LAUNCHED("launched", false, Optional.absent()),
    TASK_STAGING("staging", false, Optional.of(Protos.TaskState.TASK_STAGING)),
    TASK_STARTING("starting", false, Optional.of(Protos.TaskState.TASK_STARTING)),
    TASK_RUNNING("running", false, Optional.of(Protos.TaskState.TASK_RUNNING)),
    TASK_CLEANING("cleaning", false, Optional.absent()),
    TASK_KILLING("killing", false, Optional.of(Protos.TaskState.TASK_KILLING)),
    TASK_FINISHED("finished", true, Optional.of(Protos.TaskState.TASK_FINISHED)),
    TASK_FAILED("failed", true, Optional.of(Protos.TaskState.TASK_FAILED)),
    TASK_KILLED("killed", true, Optional.of(Protos.TaskState.TASK_KILLED)),
    TASK_LOST("lost", true, Optional.of(Protos.TaskState.TASK_LOST)),
    TASK_LOST_WHILE_DOWN("lost", true, Optional.absent()),
    TASK_ERROR("error", true, Optional.of(Protos.TaskState.TASK_ERROR));

    private static final Map<Protos.TaskState, ExtendedTaskState> map;
    private final String displayName;
    private final boolean isDone;
    private final Optional<Protos.TaskState> taskState;

    private ExtendedTaskState(String displayName, boolean isDone, Optional<Protos.TaskState> taskState) {
        this.displayName = displayName;
        this.isDone = isDone;
        this.taskState = taskState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public boolean isFailed() {
        return this == TASK_FAILED;
    }

    public boolean isSuccess() {
        return this == TASK_FINISHED;
    }

    public Optional<Protos.TaskState> toTaskState() {
        return this.taskState;
    }

    public static ExtendedTaskState fromTaskState(Protos.TaskState taskState) {
        ExtendedTaskState extendedTaskState = map.get(taskState);
        Preconditions.checkArgument(extendedTaskState != null, "No ExtendedTaskState for TaskState %s", taskState);
        return extendedTaskState;
    }

    static {
        map = Maps.newHashMapWithExpectedSize(ExtendedTaskState.values().length);
        for (ExtendedTaskState extendedTaskState : ExtendedTaskState.values()) {
            if (!extendedTaskState.toTaskState().isPresent()) continue;
            map.put(extendedTaskState.toTaskState().get(), extendedTaskState);
        }
        for (Enum enum_ : Protos.TaskState.values()) {
            if (map.get(enum_) != null) continue;
            throw new IllegalStateException("No ExtendedTaskState provided for TaskState " + enum_ + ", you probably have incompatible versions of Mesos and Singularity.");
        }
    }
}

