/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.SingularityPortMappingType;

public class SingularityDockerPortMapping {
    public static final String DEFAULT_PROTOCOL = "tcp";
    public static final SingularityPortMappingType DEFAULT_PORT_MAPPING_TYPE = SingularityPortMappingType.LITERAL;
    private final SingularityPortMappingType containerPortType;
    private final SingularityPortMappingType hostPortType;
    private final int containerPort;
    private final int hostPort;
    private final String protocol;

    @JsonCreator
    public SingularityDockerPortMapping(@JsonProperty(value="containerPortType") Optional<SingularityPortMappingType> containerPortType, @JsonProperty(value="containerPort") int containerPort, @JsonProperty(value="hostPortType") Optional<SingularityPortMappingType> hostPortType, @JsonProperty(value="hostPort") int hostPort, @JsonProperty(value="protocol") Optional<String> protocol) {
        this.containerPortType = containerPortType.or(DEFAULT_PORT_MAPPING_TYPE);
        this.containerPort = containerPort;
        this.hostPortType = hostPortType.or(DEFAULT_PORT_MAPPING_TYPE);
        this.hostPort = hostPort;
        this.protocol = protocol.or(DEFAULT_PROTOCOL);
    }

    public SingularityPortMappingType getContainerPortType() {
        return this.containerPortType;
    }

    public int getContainerPort() {
        return this.containerPort;
    }

    public SingularityPortMappingType getHostPortType() {
        return this.hostPortType;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String toString() {
        return "SingularityDockerPortMapping[containerPortType=" + (Object)((Object)this.containerPortType) + ", hostPortType=" + (Object)((Object)this.hostPortType) + ", containerPort=" + this.containerPort + ", hostPort=" + this.hostPort + ", protocol=" + this.protocol + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityDockerPortMapping that = (SingularityDockerPortMapping)o;
        if (!this.containerPortType.equals((Object)that.containerPortType)) {
            return false;
        }
        if (this.containerPort != that.containerPort) {
            return false;
        }
        if (!this.hostPortType.equals((Object)that.hostPortType)) {
            return false;
        }
        return this.protocol.equals(that.protocol);
    }

    public int hashCode() {
        int result = this.containerPortType.hashCode();
        result = 31 * result + this.hostPortType.hashCode();
        result = 31 * result + this.containerPort;
        result = 31 * result + this.hostPort;
        result = 31 * result + this.protocol.hashCode();
        return result;
    }
}

