/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

public class Resources {
    public static final Resources EMPTY_RESOURCES = new Resources(0.0, 0.0, 0);
    private final double cpus;
    private final double memoryMb;
    private final int numPorts;

    public static Resources add(Resources a, Resources b) {
        Preconditions.checkNotNull(a, "first argument of Resources.add() is null");
        Preconditions.checkNotNull(b, "second argument of Resources.add() is null");
        return new Resources(a.getCpus() + b.getCpus(), a.getMemoryMb() + b.getMemoryMb(), a.getNumPorts() + b.getNumPorts());
    }

    @JsonCreator
    public Resources(@JsonProperty(value="cpus") double cpus, @JsonProperty(value="memoryMb") double memoryMb, @JsonProperty(value="numPorts") int numPorts) {
        this.cpus = cpus;
        this.memoryMb = memoryMb;
        this.numPorts = numPorts;
    }

    public int getNumPorts() {
        return this.numPorts;
    }

    public double getCpus() {
        return this.cpus;
    }

    public double getMemoryMb() {
        return this.memoryMb;
    }

    public String toString() {
        return "Resources [cpus=" + this.cpus + ", memoryMb=" + this.memoryMb + ", numPorts=" + this.numPorts + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resources resources = (Resources)o;
        if (Double.compare(resources.cpus, this.cpus) != 0) {
            return false;
        }
        if (Double.compare(resources.memoryMb, this.memoryMb) != 0) {
            return false;
        }
        return this.numPorts == resources.numPorts;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.cpus);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.memoryMb);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.numPorts;
        return result;
    }
}

