/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;
import com.hubspot.jackson.datatype.protobuf.PropertyNamingStrategyWrapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProtobufSerializer
extends StdSerializer<MessageOrBuilder> {
    private final Map<Class<?>, JsonSerializer<Object>> serializerCache = new ConcurrentHashMap();

    public ProtobufSerializer() {
        super(MessageOrBuilder.class);
    }

    @Override
    public void serialize(MessageOrBuilder message, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        generator.writeStartObject();
        PropertyNamingStrategyWrapper namingStrategy = new PropertyNamingStrategyWrapper(serializerProvider.getConfig().getPropertyNamingStrategy());
        for (Map.Entry<Descriptors.FieldDescriptor, Object> record : message.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field = record.getKey();
            Object value = record.getValue();
            if (field.isRepeated()) {
                List valueList = (List)value;
                if (valueList.size() == 1 && ProtobufSerializer.writeSingleElementArraysUnwrapped(serializerProvider)) {
                    generator.writeFieldName(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()));
                    this.writeValue(field, valueList.get(0), generator, serializerProvider);
                    continue;
                }
                generator.writeArrayFieldStart(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()));
                for (Object subValue : valueList) {
                    this.writeValue(field, subValue, generator, serializerProvider);
                }
                generator.writeEndArray();
                continue;
            }
            generator.writeFieldName(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()));
            this.writeValue(field, value, generator, serializerProvider);
        }
        if (ProtobufSerializer.writeEmptyArrays(serializerProvider)) {
            for (Descriptors.FieldDescriptor field : message.getDescriptorForType().getFields()) {
                List valueList;
                if (!field.isRepeated() || !(valueList = (List)message.getField(field)).isEmpty()) continue;
                generator.writeArrayFieldStart(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()));
                generator.writeEndArray();
            }
        }
        generator.writeEndObject();
    }

    private void writeValue(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        switch (field.getJavaType()) {
            case INT: {
                generator.writeNumber((Integer)value);
                break;
            }
            case LONG: {
                generator.writeNumber((Long)value);
                break;
            }
            case FLOAT: {
                generator.writeNumber(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                generator.writeNumber((Double)value);
                break;
            }
            case BOOLEAN: {
                generator.writeBoolean((Boolean)value);
                break;
            }
            case STRING: {
                generator.writeString((String)value);
                break;
            }
            case ENUM: {
                Descriptors.EnumValueDescriptor enumDescriptor = (Descriptors.EnumValueDescriptor)value;
                if (ProtobufSerializer.writeEnumsUsingIndex(serializerProvider)) {
                    generator.writeNumber(enumDescriptor.getNumber());
                    break;
                }
                generator.writeString(enumDescriptor.getName());
                break;
            }
            case BYTE_STRING: {
                generator.writeString(serializerProvider.getConfig().getBase64Variant().encode(((ByteString)value).toByteArray()));
                break;
            }
            case MESSAGE: {
                Class<?> subType = value.getClass();
                JsonSerializer<Object> serializer = this.serializerCache.get(subType);
                if (serializer == null) {
                    serializer = serializerProvider.findValueSerializer(value.getClass(), null);
                    this.serializerCache.put(subType, serializer);
                }
                serializer.serialize(value, generator, serializerProvider);
                break;
            }
            default: {
                throw ProtobufSerializer.unrecognizedType(field);
            }
        }
    }

    private static boolean writeEmptyArrays(SerializerProvider config) {
        return config.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
    }

    private static boolean writeSingleElementArraysUnwrapped(SerializerProvider config) {
        return config.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
    }

    private static boolean writeEnumsUsingIndex(SerializerProvider config) {
        return config.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
    }

    private static IOException unrecognizedType(Descriptors.FieldDescriptor field) throws IOException {
        String error = String.format("Unrecognized java type '%s' for field %s", new Object[]{field.getJavaType(), field.getFullName()});
        throw new JsonMappingException(error);
    }
}

