/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.deploy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.deploy.EmbeddedArtifact;
import com.hubspot.deploy.ExecutorDataBuilder;
import com.hubspot.deploy.ExternalArtifact;
import com.hubspot.deploy.S3Artifact;
import com.hubspot.deploy.S3ArtifactSignature;
import com.hubspot.mesos.JavaUtils;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExecutorData {
    private final String cmd;
    private final List<EmbeddedArtifact> embeddedArtifacts;
    private final List<ExternalArtifact> externalArtifacts;
    private final List<S3Artifact> s3Artifacts;
    private final List<Integer> successfulExitCodes;
    private final Optional<String> runningSentinel;
    private final Optional<String> user;
    private final List<String> extraCmdLineArgs;
    private final Optional<String> loggingTag;
    private final Map<String, String> loggingExtraFields;
    private final Optional<Long> sigKillProcessesAfterMillis;
    private final Optional<Integer> maxTaskThreads;
    private final Optional<Boolean> preserveTaskSandboxAfterFinish;
    private final Optional<String> loggingS3Bucket;
    private final Optional<Integer> maxOpenFiles;
    private final Optional<Boolean> skipLogrotateAndCompress;
    private final Optional<List<S3ArtifactSignature>> s3ArtifactSignatures;

    @JsonCreator
    public ExecutorData(@JsonProperty(value="cmd") String cmd, @JsonProperty(value="embeddedArtifacts") List<EmbeddedArtifact> embeddedArtifacts, @JsonProperty(value="externalArtifacts") List<ExternalArtifact> externalArtifacts, @JsonProperty(value="s3Artifacts") List<S3Artifact> s3Artifacts, @JsonProperty(value="successfulExitCodes") List<Integer> successfulExitCodes, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="runningSentinel") Optional<String> runningSentinel, @JsonProperty(value="extraCmdLineArgs") List<String> extraCmdLineArgs, @JsonProperty(value="loggingTag") Optional<String> loggingTag, @JsonProperty(value="loggingExtraFields") Map<String, String> loggingExtraFields, @JsonProperty(value="sigKillProcessesAfterMillis") Optional<Long> sigKillProcessesAfterMillis, @JsonProperty(value="maxTaskThreads") Optional<Integer> maxTaskThreads, @JsonProperty(value="preserveTaskSandboxAfterFinish") Optional<Boolean> preserveTaskSandboxAfterFinish, @JsonProperty(value="loggingS3Bucket") Optional<String> loggingS3Bucket, @JsonProperty(value="maxOpenFiles") Optional<Integer> maxOpenFiles, @JsonProperty(value="skipLogrotateAndCompress") Optional<Boolean> skipLogrotateAndCompress, @JsonProperty(value="s3ArtifactSignatures") Optional<List<S3ArtifactSignature>> s3ArtifactSignatures) {
        this.cmd = cmd;
        this.embeddedArtifacts = JavaUtils.nonNullImmutable(embeddedArtifacts);
        this.externalArtifacts = JavaUtils.nonNullImmutable(externalArtifacts);
        this.s3Artifacts = JavaUtils.nonNullImmutable(s3Artifacts);
        this.user = user;
        this.successfulExitCodes = JavaUtils.nonNullImmutable(successfulExitCodes);
        this.extraCmdLineArgs = JavaUtils.nonNullImmutable(extraCmdLineArgs);
        this.runningSentinel = runningSentinel;
        this.loggingTag = loggingTag;
        this.loggingExtraFields = JavaUtils.nonNullImmutable(loggingExtraFields);
        this.sigKillProcessesAfterMillis = sigKillProcessesAfterMillis;
        this.maxTaskThreads = maxTaskThreads;
        this.preserveTaskSandboxAfterFinish = preserveTaskSandboxAfterFinish;
        this.loggingS3Bucket = loggingS3Bucket;
        this.maxOpenFiles = maxOpenFiles;
        this.skipLogrotateAndCompress = skipLogrotateAndCompress;
        this.s3ArtifactSignatures = s3ArtifactSignatures;
    }

    public ExecutorDataBuilder toBuilder() {
        return new ExecutorDataBuilder(this.cmd, this.embeddedArtifacts, this.externalArtifacts, this.s3Artifacts, this.successfulExitCodes, this.runningSentinel, this.user, this.extraCmdLineArgs, this.loggingTag, this.loggingExtraFields, this.sigKillProcessesAfterMillis, this.maxTaskThreads, this.preserveTaskSandboxAfterFinish, this.loggingS3Bucket, this.maxOpenFiles, this.skipLogrotateAndCompress, this.s3ArtifactSignatures);
    }

    public String getCmd() {
        return this.cmd;
    }

    public Optional<String> getLoggingTag() {
        return this.loggingTag;
    }

    public Map<String, String> getLoggingExtraFields() {
        return this.loggingExtraFields;
    }

    public List<EmbeddedArtifact> getEmbeddedArtifacts() {
        return this.embeddedArtifacts;
    }

    public List<ExternalArtifact> getExternalArtifacts() {
        return this.externalArtifacts;
    }

    public List<Integer> getSuccessfulExitCodes() {
        return this.successfulExitCodes;
    }

    public List<String> getExtraCmdLineArgs() {
        return this.extraCmdLineArgs;
    }

    public Optional<String> getRunningSentinel() {
        return this.runningSentinel;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public Optional<Long> getSigKillProcessesAfterMillis() {
        return this.sigKillProcessesAfterMillis;
    }

    public List<S3Artifact> getS3Artifacts() {
        return this.s3Artifacts;
    }

    public Optional<Integer> getMaxTaskThreads() {
        return this.maxTaskThreads;
    }

    public Optional<Boolean> getPreserveTaskSandboxAfterFinish() {
        return this.preserveTaskSandboxAfterFinish;
    }

    public Optional<String> getLoggingS3Bucket() {
        return this.loggingS3Bucket;
    }

    public Optional<Integer> getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    public Optional<Boolean> getSkipLogrotateAndCompress() {
        return this.skipLogrotateAndCompress;
    }

    public Optional<List<S3ArtifactSignature>> getS3ArtifactSignatures() {
        return this.s3ArtifactSignatures;
    }

    public String toString() {
        return "ExecutorData[cmd='" + this.cmd + '\'' + ", embeddedArtifacts=" + this.embeddedArtifacts + ", externalArtifacts=" + this.externalArtifacts + ", s3Artifacts=" + this.s3Artifacts + ", successfulExitCodes=" + this.successfulExitCodes + ", runningSentinel=" + this.runningSentinel + ", user=" + this.user + ", extraCmdLineArgs=" + this.extraCmdLineArgs + ", loggingTag=" + this.loggingTag + ", loggingExtraFields=" + this.loggingExtraFields + ", sigKillProcessesAfterMillis=" + this.sigKillProcessesAfterMillis + ", maxTaskThreads=" + this.maxTaskThreads + ", preserveTaskSandboxAfterFinish=" + this.preserveTaskSandboxAfterFinish + ", loggingS3Bucket=" + this.loggingS3Bucket + ", maxOpenFiles=" + this.maxOpenFiles + ", skipLogrotateAndCompress=" + this.skipLogrotateAndCompress + ", s3ArtifactSignatures=" + this.s3ArtifactSignatures + ']';
    }
}

