/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonService {
    @NotNull
    @Pattern(regexp="[^\\s/|]+", message="cannot contain whitespace, '/', or '|'", flags={Pattern.Flag.MULTILINE})
    private final String serviceId;
    @NotNull
    private final Collection<String> owners;
    @NotNull
    private final String serviceBasePath;
    private final List<String> additionalPaths;
    @NotNull
    @Size(min=1)
    private final Set<String> loadBalancerGroups;
    private final Map<String, Object> options;
    private final Optional<String> templateName;
    private final Set<String> domains;

    public BaragonService(@JsonProperty(value="serviceId") String serviceId, @JsonProperty(value="owners") Collection<String> owners, @JsonProperty(value="serviceBasePath") String serviceBasePath, @JsonProperty(value="additionalPaths") List<String> additionalPaths, @JsonProperty(value="loadBalancerGroups") Set<String> loadBalancerGroups, @JsonProperty(value="options") Map<String, Object> options, @JsonProperty(value="templateName") Optional<String> templateName, @JsonProperty(value="domains") Set<String> domains) {
        this.serviceId = serviceId;
        this.owners = owners;
        this.serviceBasePath = serviceBasePath;
        this.additionalPaths = Objects.firstNonNull(additionalPaths, Collections.emptyList());
        this.loadBalancerGroups = loadBalancerGroups;
        this.options = options;
        this.templateName = templateName;
        this.domains = Objects.firstNonNull(domains, Collections.emptySet());
    }

    public BaragonService(String serviceId, Collection<String> owners, String serviceBasePath, List<String> additionalPaths, Set<String> loadBalancerGroups, Map<String, Object> options, Optional<String> templateName) {
        this(serviceId, owners, serviceBasePath, additionalPaths, loadBalancerGroups, options, templateName, Collections.emptySet());
    }

    public BaragonService(String serviceId, Collection<String> owners, String serviceBasePath, Set<String> loadBalancerGroups, Map<String, Object> options) {
        this(serviceId, owners, serviceBasePath, Collections.emptyList(), loadBalancerGroups, options, Optional.absent(), Collections.emptySet());
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public Collection<String> getOwners() {
        return this.owners;
    }

    public String getServiceBasePath() {
        return this.serviceBasePath;
    }

    public List<String> getAdditionalPaths() {
        return this.additionalPaths;
    }

    public Set<String> getLoadBalancerGroups() {
        return this.loadBalancerGroups;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public Optional<String> getTemplateName() {
        return this.templateName;
    }

    public Set<String> getDomains() {
        return this.domains;
    }

    @JsonIgnore
    public List<String> getAllPaths() {
        ArrayList<String> allPaths = new ArrayList<String>();
        for (String path : this.additionalPaths) {
            if (!this.domains.isEmpty()) {
                for (String domain : this.domains) {
                    allPaths.add(String.format("%s%s", domain, path));
                }
                continue;
            }
            allPaths.add(path);
        }
        if (!this.domains.isEmpty()) {
            for (String domain : this.domains) {
                allPaths.add(String.format("%s%s", domain, this.serviceBasePath));
            }
        } else {
            allPaths.add(this.serviceBasePath);
        }
        return allPaths;
    }

    public String toString() {
        return "BaragonService [serviceId='" + this.serviceId + '\'' + ", owners=" + this.owners + ", serviceBasePath='" + this.serviceBasePath + '\'' + ", loadBalancerGroups=" + this.loadBalancerGroups + ", options=" + this.options + ", templateName=" + this.templateName + ", domains=" + this.domains + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonService service = (BaragonService)o;
        if (this.loadBalancerGroups != null ? !this.loadBalancerGroups.equals(service.loadBalancerGroups) : service.loadBalancerGroups != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(service.options) : service.options != null) {
            return false;
        }
        if (this.owners != null ? !this.owners.equals(service.owners) : service.owners != null) {
            return false;
        }
        if (this.serviceBasePath != null ? !this.serviceBasePath.equals(service.serviceBasePath) : service.serviceBasePath != null) {
            return false;
        }
        if (this.additionalPaths != null ? !this.additionalPaths.equals(service.additionalPaths) : service.additionalPaths != null) {
            return false;
        }
        if (this.serviceId != null ? !this.serviceId.equals(service.serviceId) : service.serviceId != null) {
            return false;
        }
        if (this.templateName != null ? !this.templateName.equals(service.templateName) : service.templateName != null) {
            return false;
        }
        return !(this.domains != null ? !this.domains.equals(service.domains) : service.domains != null);
    }

    public int hashCode() {
        int result = this.serviceId != null ? this.serviceId.hashCode() : 0;
        result = 31 * result + (this.owners != null ? this.owners.hashCode() : 0);
        result = 31 * result + (this.serviceBasePath != null ? this.serviceBasePath.hashCode() : 0);
        result = 31 * result + (this.additionalPaths != null ? this.additionalPaths.hashCode() : 0);
        result = 31 * result + (this.loadBalancerGroups != null ? this.loadBalancerGroups.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        result = 31 * result + (this.templateName != null ? this.templateName.hashCode() : 0);
        result = 31 * result + (this.domains != null ? this.domains.hashCode() : 0);
        return result;
    }
}

