/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.hubspot.baragon.exceptions.InvalidAgentMetadataStringException;
import com.hubspot.baragon.models.BaragonAgentEc2Metadata;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonAgentMetadata {
    public static final Pattern AGENT_METADATA_STRING_REGEX = Pattern.compile("^http[s]?:\\/\\/([^:\\/]+:\\d{1,5})\\/.*$");
    private final String baseAgentUri;
    @Deprecated
    private final Optional<String> domain;
    private final String agentId;
    private final BaragonAgentEc2Metadata ec2;
    private final Map<String, String> extraAgentData;

    @JsonCreator
    public static BaragonAgentMetadata fromString(String value) {
        Matcher matcher = AGENT_METADATA_STRING_REGEX.matcher(value);
        if (!matcher.matches()) {
            throw new InvalidAgentMetadataStringException(value);
        }
        return new BaragonAgentMetadata(value, matcher.group(1), Optional.absent(), new BaragonAgentEc2Metadata(Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent()), Collections.emptyMap());
    }

    @JsonCreator
    public BaragonAgentMetadata(@JsonProperty(value="baseAgentUri") String baseAgentUri, @JsonProperty(value="agentId") String agentId, @JsonProperty(value="domain") Optional<String> domain, @JsonProperty(value="ec2") BaragonAgentEc2Metadata ec2, @JsonProperty(value="extraAgentData") Map<String, String> extraAgentData) {
        this.baseAgentUri = baseAgentUri;
        this.domain = domain;
        this.agentId = agentId;
        this.ec2 = ec2;
        this.extraAgentData = Objects.firstNonNull(extraAgentData, Collections.emptyMap());
    }

    public String getBaseAgentUri() {
        return this.baseAgentUri;
    }

    @Deprecated
    public Optional<String> getDomain() {
        return this.domain;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public BaragonAgentEc2Metadata getEc2() {
        return this.ec2;
    }

    public Map<String, String> getExtraAgentData() {
        return this.extraAgentData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonAgentMetadata metadata = (BaragonAgentMetadata)o;
        if (this.agentId != null ? !this.agentId.equals(metadata.agentId) : metadata.agentId != null) {
            return false;
        }
        if (!this.baseAgentUri.equals(metadata.baseAgentUri)) {
            return false;
        }
        if (!this.domain.equals(metadata.domain)) {
            return false;
        }
        if (!this.ec2.equals(metadata.ec2)) {
            return false;
        }
        return this.extraAgentData.equals(metadata.extraAgentData);
    }

    public int hashCode() {
        int result = this.baseAgentUri.hashCode();
        result = 31 * result + this.domain.hashCode();
        result = 31 * result + (this.agentId != null ? this.agentId.hashCode() : 0);
        result = 31 * result + (this.ec2 != null ? this.ec2.hashCode() : 0);
        result = 31 * result + this.extraAgentData.hashCode();
        return result;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("baseAgentUri", this.baseAgentUri).add("domain", this.domain).add("agentId", this.agentId).add("ec2", this.ec2).add("extraAgentData", this.extraAgentData).toString();
    }
}

