/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.amazonaws.util.EC2MetadataUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonAgentEc2Metadata {
    private final Optional<String> instanceId;
    private final Optional<String> availabilityZone;
    private final Optional<String> subnetId;
    private final Optional<String> vpcId;

    @JsonCreator
    public BaragonAgentEc2Metadata(@JsonProperty(value="instanceId") Optional<String> instanceId, @JsonProperty(value="availabilityZone") Optional<String> availabilityZone, @JsonProperty(value="subnetId") Optional<String> subnetId, @JsonProperty(value="vpcId") Optional<String> vpcId) {
        this.instanceId = instanceId;
        this.availabilityZone = availabilityZone;
        this.subnetId = subnetId;
        this.vpcId = vpcId;
    }

    public static BaragonAgentEc2Metadata fromEnvironment() {
        return new BaragonAgentEc2Metadata(BaragonAgentEc2Metadata.findInstanceId(), BaragonAgentEc2Metadata.findAvailabilityZone(), BaragonAgentEc2Metadata.findSubnet(), BaragonAgentEc2Metadata.findVpc());
    }

    public static Optional<String> findInstanceId() {
        try {
            return Optional.fromNullable(EC2MetadataUtils.getInstanceId());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    public static Optional<String> findAvailabilityZone() {
        try {
            return Optional.fromNullable(EC2MetadataUtils.getAvailabilityZone());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    private static Optional<String> findSubnet() {
        try {
            List<EC2MetadataUtils.NetworkInterface> networkInterfaces = EC2MetadataUtils.getNetworkInterfaces();
            if (EC2MetadataUtils.getNetworkInterfaces().isEmpty()) {
                return Optional.absent();
            }
            return Optional.fromNullable(networkInterfaces.get(0).getSubnetId());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    private static Optional<String> findVpc() {
        try {
            List<EC2MetadataUtils.NetworkInterface> networkInterfaces = EC2MetadataUtils.getNetworkInterfaces();
            if (EC2MetadataUtils.getNetworkInterfaces().isEmpty()) {
                return Optional.absent();
            }
            return Optional.fromNullable(networkInterfaces.get(0).getVpcId());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    public Optional<String> getInstanceId() {
        return this.instanceId;
    }

    public Optional<String> getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Optional<String> getSubnetId() {
        return this.subnetId;
    }

    public Optional<String> getVpcId() {
        return this.vpcId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonAgentEc2Metadata that = (BaragonAgentEc2Metadata)o;
        if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) {
            return false;
        }
        if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) {
            return false;
        }
        if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) {
            return false;
        }
        return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
    }

    public int hashCode() {
        int result = this.instanceId != null ? this.instanceId.hashCode() : 0;
        result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
        result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
        result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BaragonAgentEc2Metadata{instanceId=" + this.instanceId + ", availabilityZone=" + this.availabilityZone + ", subnetId=" + this.subnetId + ", vpcId=" + this.vpcId + '}';
    }
}

