/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import java.io.IOException;
import java.lang.annotation.Annotation;

abstract class OptimizedSettableBeanProperty<T extends OptimizedSettableBeanProperty<T>>
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final SettableBeanProperty _originalSettable;
    protected final BeanPropertyMutator _propertyMutator;
    protected final int _optimizedIndex;

    public OptimizedSettableBeanProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src);
        this._originalSettable = src;
        this._propertyMutator = mutator;
        this._optimizedIndex = index;
    }

    protected OptimizedSettableBeanProperty(OptimizedSettableBeanProperty<T> src, JsonDeserializer<?> deser) {
        super(src, deser);
        this._originalSettable = src._originalSettable.withValueDeserializer(deser);
        this._propertyMutator = src._propertyMutator;
        this._optimizedIndex = src._optimizedIndex;
    }

    protected OptimizedSettableBeanProperty(OptimizedSettableBeanProperty<T> src, PropertyName name) {
        super(src, name);
        this._originalSettable = src._originalSettable.withName(name);
        this._propertyMutator = src._propertyMutator;
        this._optimizedIndex = src._optimizedIndex;
    }

    @Override
    public abstract SettableBeanProperty withValueDeserializer(JsonDeserializer<?> var1);

    public abstract SettableBeanProperty withMutator(BeanPropertyMutator var1);

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> ann) {
        return this._originalSettable.getAnnotation(ann);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._originalSettable.getMember();
    }

    @Override
    public abstract void deserializeAndSet(JsonParser var1, DeserializationContext var2, Object var3) throws IOException, JsonProcessingException;

    @Override
    public abstract void set(Object var1, Object var2) throws IOException;

    @Override
    public abstract Object deserializeSetAndReturn(JsonParser var1, DeserializationContext var2, Object var3) throws IOException;

    @Override
    public Object setAndReturn(Object instance, Object value) throws IOException {
        return this._originalSettable.setAndReturn(instance, value);
    }

    public SettableBeanProperty getOriginalProperty() {
        return this._originalSettable;
    }

    public int getOptimizedIndex() {
        return this._optimizedIndex;
    }

    protected final boolean _deserializeBoolean(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (t == JsonToken.VALUE_NULL) {
            return false;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            if (p.getNumberType() == JsonParser.NumberType.INT) {
                return p.getIntValue() != 0;
            }
            return this._deserializeBooleanFromOther(p, ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = p.getText().trim();
            if ("true".equals(text) || "True".equals(text)) {
                return true;
            }
            if ("false".equals(text) || "False".equals(text) || text.length() == 0) {
                return false;
            }
            if (this._hasTextualNull(text)) {
                return false;
            }
            throw ctxt.weirdStringException(text, Boolean.TYPE, "only \"true\" or \"false\" recognized");
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            boolean parsed = this._deserializeBooleanFromOther(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(p, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'boolean' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(Boolean.TYPE, t);
    }

    protected final short _deserializeShort(JsonParser jp, DeserializationContext ctxt) throws IOException {
        int value = this._deserializeInt(jp, ctxt);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw ctxt.weirdStringException(String.valueOf(value), Short.TYPE, "overflow, value can not be represented as 16-bit value");
        }
        return (short)value;
    }

    protected final int _deserializeInt(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return p.getIntValue();
        }
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            String text = p.getText().trim();
            if (this._hasTextualNull(text)) {
                return 0;
            }
            try {
                int len = text.length();
                if (len > 9) {
                    long l = Long.parseLong(text);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw ctxt.weirdStringException(text, Integer.TYPE, "Overflow: numeric value (" + text + ") out of range of int (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l;
                }
                if (len == 0) {
                    return 0;
                }
                return NumberInput.parseInt(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, Integer.TYPE, "not a valid int value");
            }
        }
        if (t == JsonToken.VALUE_NUMBER_FLOAT) {
            if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                this._failDoubleToIntCoercion(p, ctxt, "int");
            }
            return p.getValueAsInt();
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            int parsed = this._deserializeInt(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(p, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'int' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(Integer.TYPE, t);
    }

    protected final long _deserializeLong(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 7: {
                return p.getLongValue();
            }
            case 8: {
                if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(p, ctxt, "long");
                }
                return p.getValueAsLong();
            }
            case 6: {
                String text = p.getText().trim();
                if (text.length() == 0 || this._hasTextualNull(text)) {
                    return 0L;
                }
                try {
                    return NumberInput.parseLong(text);
                }
                catch (IllegalArgumentException iae) {
                    throw ctxt.weirdStringException(text, Long.TYPE, "not a valid long value");
                }
            }
            case 11: {
                return 0L;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                long parsed = this._deserializeLong(p, ctxt);
                JsonToken t = p.nextToken();
                if (t != JsonToken.END_ARRAY) {
                    throw ctxt.wrongTokenException(p, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'long' value but there was more than a single value in the array");
                }
                return parsed;
            }
        }
        throw ctxt.mappingException(Long.TYPE, p.getCurrentToken());
    }

    protected final String _deserializeString(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 6: {
                return p.getText();
            }
            case 11: {
                return null;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                String parsed = this._deserializeString(p, ctxt);
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    throw ctxt.wrongTokenException(p, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'String' value but there was more than a single value in the array");
                }
                return parsed;
            }
            case 12: {
                Object ob = p.getEmbeddedObject();
                if (ob == null) {
                    return null;
                }
                if (ob instanceof byte[]) {
                    return Base64Variants.getDefaultVariant().encode((byte[])ob, false);
                }
                return ob.toString();
            }
            default: {
                String text = p.getValueAsString();
                if (text == null) break;
                return text;
            }
        }
        throw ctxt.mappingException(String.class, p.getCurrentToken());
    }

    protected final boolean _deserializeBooleanFromOther(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.getNumberType() == JsonParser.NumberType.LONG) {
            return p.getLongValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
        String str = p.getText();
        if ("0.0".equals(str) || "0".equals(str)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected void _failDoubleToIntCoercion(JsonParser p, DeserializationContext ctxt, String type) throws IOException {
        throw ctxt.mappingException("Can not coerce a floating-point value ('%s') into %s; enable `DeserializationFeature.ACCEPT_FLOAT_AS_INT` to allow", p.getValueAsString(), type);
    }

    protected boolean _hasTextualNull(String value) {
        return "null".equals(value);
    }

    protected boolean _isDefaultDeserializer(JsonDeserializer<?> deser) {
        return deser == null || ClassUtil.isJacksonStdImpl(deser);
    }
}

