/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import org.joda.time.DateTime;

public class DateTimeSerializer
extends JodaDateSerializerBase<DateTime> {
    private static final long serialVersionUID = 1L;

    public DateTimeSerializer() {
        this(FormatConfig.DEFAULT_DATETIME_PRINTER);
    }

    public DateTimeSerializer(JacksonJodaDateFormat format) {
        super(DateTime.class, format, false, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public DateTimeSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new DateTimeSerializer(formatter);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, DateTime value) {
        return value.getMillis() == 0L;
    }

    @Override
    public void serialize(DateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (!provider.isEnabled(SerializationFeature.WRITE_DATES_WITH_ZONE_ID)) {
            if (this._useTimestamp(provider)) {
                gen.writeNumber(value.getMillis());
            } else {
                gen.writeString(this._format.createFormatter(provider).print(value));
            }
        } else {
            if (this._useTimestamp(provider)) {
                gen.writeNumber(value.getMillis());
                return;
            }
            StringBuilder sb = new StringBuilder(40).append(this._format.createFormatter(provider).withOffsetParsed().print(value));
            sb = sb.append('[').append(value.getZone()).append(']');
            gen.writeString(sb.toString());
        }
    }
}

