/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.hubspot.singularity.SingularityTaskShellCommandRequest;
import com.hubspot.singularity.SingularityTaskShellCommandUpdate;
import com.hubspot.singularity.executor.SingularityExecutorMonitor;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.shells.SingularityExecutorShellCommandRunner;
import com.hubspot.singularity.executor.shells.SingularityExecutorShellCommandUpdater;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskProcessCallable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingularityExecutorMesosFrameworkMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SingularityExecutorMesosFrameworkMessageHandler.class);
    private final SingularityExecutorMonitor monitor;
    private final SingularityExecutorConfiguration executorConfiguration;
    private final ObjectMapper objectMapper;

    @Inject
    public SingularityExecutorMesosFrameworkMessageHandler(ObjectMapper objectMapper, SingularityExecutorMonitor monitor, SingularityExecutorConfiguration executorConfiguration) {
        this.objectMapper = objectMapper;
        this.monitor = monitor;
        this.executorConfiguration = executorConfiguration;
    }

    public void handleMessage(byte[] data) {
        try {
            SingularityTaskShellCommandRequest shellRequest = (SingularityTaskShellCommandRequest)this.objectMapper.readValue(data, SingularityTaskShellCommandRequest.class);
            Optional<SingularityExecutorTask> matchingTask = this.monitor.getTask(shellRequest.getTaskId().getId());
            if (!matchingTask.isPresent()) {
                LOG.warn("Missing task for {}, ignoring shell request", (Object)shellRequest.getTaskId());
                return;
            }
            ((SingularityExecutorTask)matchingTask.get()).getLog().info("Received shell request {}", (Object)shellRequest);
            SingularityExecutorShellCommandUpdater updater = new SingularityExecutorShellCommandUpdater(this.objectMapper, shellRequest, (SingularityExecutorTask)matchingTask.get());
            Optional<SingularityExecutorTaskProcessCallable> taskProcess = this.monitor.getTaskProcess(shellRequest.getTaskId().getId());
            if (!taskProcess.isPresent()) {
                updater.sendUpdate(SingularityTaskShellCommandUpdate.UpdateType.INVALID, (Optional<String>)Optional.of((Object)"No task process found"), (Optional<String>)Optional.absent());
                return;
            }
            SingularityExecutorShellCommandRunner shellRunner = new SingularityExecutorShellCommandRunner(shellRequest, this.executorConfiguration, (SingularityExecutorTask)matchingTask.get(), (SingularityExecutorTaskProcessCallable)taskProcess.get(), this.monitor.getShellCommandExecutorServiceForTask(shellRequest.getTaskId().getId()), updater);
            shellRunner.start();
        }
        catch (IOException e) {
            LOG.warn("Framework message {} not a shell request", (Object)new String(data, StandardCharsets.UTF_8));
        }
    }
}

