/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import jersey.repackaged.com.google.common.util.concurrent.SettableFuture;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.AbortException;
import org.glassfish.jersey.client.ClientAsyncExecutorFactory;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientFilteringStages;
import org.glassfish.jersey.client.ClientLifecycleListener;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.RequestProcessingInitializationStage;
import org.glassfish.jersey.client.ResponseCallback;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;

class ClientRuntime
implements JerseyClient.ShutdownHook {
    private static final Logger LOG = Logger.getLogger(ClientRuntime.class.getName());
    private final Stage<ClientRequest> requestProcessingRoot;
    private final Stage<ClientResponse> responseProcessingRoot;
    private final Connector connector;
    private final ClientConfig config;
    private final RequestScope requestScope;
    private final ClientAsyncExecutorFactory asyncExecutorsFactory;
    private final ServiceLocator locator;
    private final Iterable<ClientLifecycleListener> lifecycleListeners;

    public ClientRuntime(ClientConfig config, Connector connector, ServiceLocator locator) {
        Stage.Builder<ClientRequest> requestingChainBuilder = Stages.chain(locator.createAndInitialize(RequestProcessingInitializationStage.class));
        ChainableStage<ClientRequest> requestFilteringStage = ClientFilteringStages.createRequestFilteringStage(locator);
        this.requestProcessingRoot = requestFilteringStage != null ? requestingChainBuilder.build(requestFilteringStage) : requestingChainBuilder.build();
        ChainableStage<ClientResponse> responseFilteringStage = ClientFilteringStages.createResponseFilteringStage(locator);
        this.responseProcessingRoot = responseFilteringStage != null ? responseFilteringStage : Stages.identity();
        this.config = config;
        this.connector = connector;
        this.requestScope = locator.getService(RequestScope.class, new Annotation[0]);
        int asyncThreadPoolSize = ClientProperties.getValue(config.getProperties(), "jersey.config.client.async.threadPoolSize", 0);
        asyncThreadPoolSize = asyncThreadPoolSize < 0 ? 0 : asyncThreadPoolSize;
        this.asyncExecutorsFactory = new ClientAsyncExecutorFactory(locator, asyncThreadPoolSize);
        this.locator = locator;
        this.lifecycleListeners = Providers.getAllProviders(locator, ClientLifecycleListener.class);
        for (ClientLifecycleListener listener : this.lifecycleListeners) {
            try {
                listener.onInit();
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, LocalizationMessages.ERROR_LISTENER_INIT(listener.getClass().getName()), t);
            }
        }
    }

    public void submit(final ClientRequest request, final ResponseCallback callback) {
        this.submit(this.asyncExecutorsFactory.getExecutor(), new Runnable(){

            @Override
            public void run() {
                ClientRequest processedRequest;
                try {
                    processedRequest = Stages.process(request, ClientRuntime.this.requestProcessingRoot);
                    processedRequest = ClientRuntime.this.addUserAgent(processedRequest, ClientRuntime.this.connector.getName());
                }
                catch (AbortException aborted) {
                    ClientRuntime.this.processResponse(aborted.getAbortResponse(), callback);
                    return;
                }
                try {
                    final SettableFuture responseFuture = SettableFuture.create();
                    AsyncConnectorCallback connectorCallback = new AsyncConnectorCallback(){

                        @Override
                        public void response(ClientResponse response) {
                            responseFuture.set(response);
                        }

                        @Override
                        public void failure(Throwable failure) {
                            responseFuture.setException(failure);
                        }
                    };
                    ClientRuntime.this.connector.apply(processedRequest, connectorCallback);
                    ClientRuntime.this.processResponse((ClientResponse)responseFuture.get(), callback);
                }
                catch (ExecutionException e) {
                    ClientRuntime.this.processFailure(e.getCause(), callback);
                }
                catch (Throwable throwable) {
                    ClientRuntime.this.processFailure(throwable, callback);
                }
            }
        });
    }

    private void processResponse(ClientResponse response, ResponseCallback callback) {
        ClientResponse processedResponse;
        try {
            processedResponse = Stages.process(response, this.responseProcessingRoot);
        }
        catch (Throwable throwable) {
            this.processFailure(throwable, callback);
            return;
        }
        callback.completed(processedResponse, this.requestScope);
    }

    private void processFailure(Throwable failure, ResponseCallback callback) {
        callback.failed(failure instanceof ProcessingException ? (ProcessingException)failure : new ProcessingException(failure));
    }

    private Future<?> submit(ExecutorService executor, final Runnable task) {
        return executor.submit(new Runnable(){

            @Override
            public void run() {
                ClientRuntime.this.requestScope.runInScope(task);
            }
        });
    }

    private ClientRequest addUserAgent(ClientRequest clientRequest, String connectorName) {
        MultivaluedMap<String, Object> headers = clientRequest.getHeaders();
        if (headers.containsKey("User-Agent")) {
            if (clientRequest.getHeaderString("User-Agent") == null) {
                headers.remove("User-Agent");
            }
        } else if (!clientRequest.ignoreUserAgent()) {
            if (connectorName != null && !connectorName.isEmpty()) {
                headers.put("User-Agent", Arrays.asList(String.format("Jersey/%s (%s)", Version.getVersion(), connectorName)));
            } else {
                headers.put("User-Agent", Arrays.asList(String.format("Jersey/%s", Version.getVersion())));
            }
        }
        return clientRequest;
    }

    public ClientResponse invoke(ClientRequest request) {
        try {
            ClientResponse response;
            try {
                response = this.connector.apply(this.addUserAgent(Stages.process(request, this.requestProcessingRoot), this.connector.getName()));
            }
            catch (AbortException aborted) {
                response = aborted.getAbortResponse();
            }
            return Stages.process(response, this.responseProcessingRoot);
        }
        catch (ProcessingException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new ProcessingException(t.getMessage(), t);
        }
    }

    public RequestScope getRequestScope() {
        return this.requestScope;
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onShutdown() {
        try {
            for (ClientLifecycleListener listener : this.lifecycleListeners) {
                try {
                    listener.onClose();
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, LocalizationMessages.ERROR_LISTENER_CLOSE(listener.getClass().getName()), t);
                }
            }
        }
        finally {
            try {
                this.connector.close();
            }
            finally {
                try {
                    this.asyncExecutorsFactory.close();
                }
                finally {
                    Injections.shutdownLocator(this.locator);
                }
            }
        }
    }

    public void preInitialize() {
        this.locator.getService(MessageBodyWorkers.class, new Annotation[0]);
    }

    public Connector getConnector() {
        return this.connector;
    }

    ServiceLocator getServiceLocator() {
        return this.locator;
    }
}

