/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.connection;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import net.kencochrane.raven.connection.AbstractConnection;
import net.kencochrane.raven.connection.ConnectionException;
import net.kencochrane.raven.event.Event;
import net.kencochrane.raven.marshaller.Marshaller;

public class OutputStreamConnection
extends AbstractConnection {
    private final OutputStream outputStream;
    private Marshaller marshaller;

    public OutputStreamConnection(OutputStream outputStream) {
        super(null, null);
        this.outputStream = outputStream;
    }

    @Override
    protected synchronized void doSend(Event event) throws ConnectionException {
        try {
            this.outputStream.write("Raven event:\n".getBytes(Charsets.UTF_8));
            this.marshaller.marshall(event, this.outputStream);
            this.outputStream.write("\n".getBytes(Charsets.UTF_8));
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new ConnectionException("Couldn't sent the event properly", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }
}

